/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplateManager;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateListener;
import com.google.security.zynamics.binnavi.debug.debugger.interfaces.IDebuggerTemplateManagerListener;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.net.NetHelpers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public final class CDebuggersModel
extends CAbstractTreeTableModel<DebuggerTemplate> {
    private static final long serialVersionUID = -884636367490425260L;
    private static final int NAME_COLUMN = 0;
    private static final int HOST_COLUMN = 1;
    private static final int PORT_COLUMN = 2;
    private static final String[] COLUMNS = new String[]{"Name", "Host", "Port"};
    private final IDatabase m_database;
    private final InternalDebuggerDescriptionManagerListener m_debuggerManagerListener = new InternalDebuggerDescriptionManagerListener();
    private final InternalDebuggerDescriptionListener m_debuggerListener = new InternalDebuggerDescriptionListener();

    public CDebuggersModel(IDatabase database) {
        this.m_database = Preconditions.checkNotNull(database, "IE01969: Database argument can't be null");
        DebuggerTemplateManager debuggerManager = this.m_database.getContent().getDebuggerTemplateManager();
        debuggerManager.addListener(this.m_debuggerManagerListener);
        for (DebuggerTemplate debugger : debuggerManager) {
            debugger.addListener(this.m_debuggerListener);
        }
    }

    private static void setHost(DebuggerTemplate debugger, String host) {
        try {
            debugger.setHost(host);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00162: Could not change the debugger host";
            String description = CUtilityFunctions.createDescription("The new debugger host could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger host was saved"}, new String[]{"The debugger host was not saved. Please try to find out what went wrong with the database connection and try to save the debugger host again."});
            NaviErrorDialog.show(null, "E00162: Could not change the debugger host", description, e2);
        }
    }

    private static void setName(DebuggerTemplate debugger, String name) {
        try {
            debugger.setName(name);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00161: Could not change the debugger name";
            String description = CUtilityFunctions.createDescription("The new debugger name could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger name was saved"}, new String[]{"The debugger name was not saved. Please try to find out what went wrong with the database connection and try to save the debugger name again."});
            NaviErrorDialog.show(null, "E00161: Could not change the debugger name", description, e2);
        }
    }

    private static void setPort(DebuggerTemplate debugger, String port) {
        try {
            if (NetHelpers.isValidPort(port)) {
                debugger.setPort(Integer.parseInt(port));
            } else {
                CMessageBox.showError(null, "Not a valid port.");
            }
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00163: Could not change the debugger port";
            String description = CUtilityFunctions.createDescription("The new debugger port could not be saved to the database.", new String[]{"There was a problem with the connection to the database while the debugger port was saved"}, new String[]{"The debugger port was not saved. Please try to find out what went wrong with the database connection and try to save the debugger port again."});
            NaviErrorDialog.show(null, "E00163: Could not change the debugger port", description, e2);
        }
    }

    @Override
    public void delete() {
        DebuggerTemplateManager debuggerManager = this.m_database.getContent().getDebuggerTemplateManager();
        debuggerManager.removeListener(this.m_debuggerManagerListener);
        for (DebuggerTemplate debugger : debuggerManager) {
            debugger.removeListener(this.m_debuggerListener);
        }
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return COLUMNS[index];
    }

    @Override
    public int getRowCount() {
        return this.m_database.getContent().getDebuggerTemplateManager().debuggerCount();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(2, new IntComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                return this.m_database.getContent().getDebuggerTemplateManager().getDebugger(row).getName();
            }
            case 1: {
                return this.m_database.getContent().getDebuggerTemplateManager().getDebugger(row).getHost();
            }
            case 2: {
                return this.m_database.getContent().getDebuggerTemplateManager().getDebugger(row).getPort();
            }
        }
        throw new IllegalStateException("IE01163: Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0 && col != 1 && col != 2) {
            throw new IllegalStateException("IE01164: Column can not be edited");
        }
        if (col == 0) {
            CDebuggersModel.setName(this.m_database.getContent().getDebuggerTemplateManager().getDebugger(row), (String)value);
        } else if (col == 1) {
            CDebuggersModel.setHost(this.m_database.getContent().getDebuggerTemplateManager().getDebugger(row), (String)value);
        } else if (col == 2) {
            CDebuggersModel.setPort(this.m_database.getContent().getDebuggerTemplateManager().getDebugger(row), value.toString());
        }
    }

    private class InternalDebuggerDescriptionManagerListener
    implements IDebuggerTemplateManagerListener {
        private InternalDebuggerDescriptionManagerListener() {
        }

        @Override
        public void addedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            debugger.addListener(CDebuggersModel.this.m_debuggerListener);
            CDebuggersModel.this.fireTableDataChanged();
        }

        @Override
        public void removedDebugger(DebuggerTemplateManager manager, DebuggerTemplate debugger) {
            debugger.removeListener(CDebuggersModel.this.m_debuggerListener);
            CDebuggersModel.this.fireTableDataChanged();
        }
    }

    private class InternalDebuggerDescriptionListener
    implements IDebuggerTemplateListener {
        private InternalDebuggerDescriptionListener() {
        }

        @Override
        public void changedHost(DebuggerTemplate debugger) {
            CDebuggersModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(DebuggerTemplate debugger) {
            CDebuggersModel.this.fireTableDataChanged();
        }

        @Override
        public void changedPort(DebuggerTemplate debugger) {
            CDebuggersModel.this.fireTableDataChanged();
        }
    }
}

