/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Database;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DatabaseManager;
import com.google.security.zynamics.binnavi.API.plugins.IDatabaseMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CCloseDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CDeleteDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CImportModuleAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.COpenDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CParentSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CDatabaseNodeMenuBuilder
extends CAbstractMenuBuilder {
    private final DefaultMutableTreeNode parentNode;
    private final IDatabase database;
    private final Action openAction;
    private final Action closeAction;
    private final InternalDatabaseListener listener = new InternalDatabaseListener();
    private boolean allowConnection = true;

    public CDatabaseNodeMenuBuilder(JTree projectTree, DefaultMutableTreeNode parentNode, IDatabase database) {
        super(projectTree);
        this.database = Preconditions.checkNotNull(database, "IE01963: Database argument can't be null");
        Preconditions.checkNotNull(projectTree, "IE02345: projectTree argument can not be null");
        this.parentNode = Preconditions.checkNotNull(parentNode, "IE02346: parentNode argument can not be null");
        this.openAction = CActionProxy.proxy(new COpenDatabaseAction(projectTree, this.database));
        this.closeAction = CActionProxy.proxy(new CCloseDatabaseAction(projectTree, this.database));
        this.updateActions(database);
        this.database.addListener(this.listener);
    }

    private void addPluginMenus(JComponent menu) {
        ArrayList<IDatabaseMenuPlugin> plugins = Lists.newArrayList();
        for (IDatabaseMenuPlugin plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IDatabaseMenuPlugin)) continue;
            plugins.add(plugin);
        }
        if (!plugins.isEmpty()) {
            menu.add(new JSeparator());
            for (IDatabaseMenuPlugin plugin : plugins) {
                try {
                    List<JComponent> menuItems = plugin.extendDatabaseMenu(this.getPluginDatabase());
                    if (menuItems == null) continue;
                    for (JComponent menuItem : menuItems) {
                        menu.add(menuItem);
                    }
                }
                catch (Exception exception) {
                    CUtilityFunctions.logException(exception);
                    String innerMessage = "E00091: Plugin caused an unexpected exception";
                    String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves errorneously from this point on but it remains active"});
                    NaviErrorDialog.show(this.getParent(), "E00091: Plugin caused an unexpected exception", innerDescription, exception);
                }
            }
        }
    }

    private Database getPluginDatabase() {
        DatabaseManager manager = PluginInterface.instance().getDatabaseManager();
        for (Database database : manager) {
            if (database.getNative() != this.database) continue;
            return database;
        }
        throw new IllegalStateException("IE01162: Unknown database");
    }

    private void updateActions(IDatabase database) {
        this.openAction.setEnabled(this.allowConnection && !database.isConnected() && !database.getConfiguration().getIdentity().isEmpty() && !database.getConfiguration().getUser().isEmpty() && !database.getConfiguration().getPassword().isEmpty());
        this.closeAction.setEnabled(database.isConnected());
    }

    @Override
    protected void createMenu(JComponent menu) {
        menu.add(new JMenuItem(this.openAction));
        menu.add(new JMenuItem(this.closeAction));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(CActionProxy.proxy(new CImportModuleAction(this.getParent(), this.database))));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteDatabaseAction(this.getParent(), this.database, new CParentSelectionUpdater(this.getProjectTree(), this.parentNode)))));
        this.addPluginMenus(menu);
    }

    @Override
    protected JMenu getMenu() {
        JMenu menu = new JMenu("Database");
        menu.setMnemonic("HK_MENU_DATABASE".charAt(0));
        return menu;
    }

    public void allowConnection(boolean allowed) {
        this.allowConnection = allowed;
        this.updateActions(this.database);
    }

    @Override
    public void dispose() {
        this.database.removeListener(this.listener);
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void closedDatabase(IDatabase database) {
            CDatabaseNodeMenuBuilder.this.updateActions(database);
        }

        @Override
        public void openedDatabase(IDatabase database) {
            CDatabaseNodeMenuBuilder.this.updateActions(database);
        }
    }
}

