/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Database;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Database.CDatabaseListenerAdapter;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.Database.CDatabaseSettingsPanel;
import com.google.security.zynamics.binnavi.Gui.Database.IDatabaseSettingsPanelListener;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.COpenDatabaseAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractLazyComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Database.CDatabaseNodeMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Database.Component.CDatabaseNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.DebuggerContainer.CDebuggerContainerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ModuleContainer.CModuleContainerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.ProjectContainer.CProjectContainerNode;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.TagContainer.CTagContainerNode;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CDatabaseNode
extends CProjectTreeNode<IDatabase> {
    private static final long serialVersionUID = 8655562357921734518L;
    private static final ImageIcon ICON_DATABASE_LOADED = new ImageIcon(CMain.class.getResource("data/projecttreeicons/database_connected.png"));
    private static final ImageIcon ICON_DATABASE_CLOSED = new ImageIcon(CMain.class.getResource("data/projecttreeicons/database_closed.png"));
    private final IDatabase m_database;
    private final InternalDatabaseListener m_listener;
    private final IDatabaseSettingsPanelListener m_panelListener = new InternalDatabaseSettingsPanelListener();

    public CDatabaseNode(JTree projectTree, DefaultMutableTreeNode parentNode, final IDatabase database) {
        super(projectTree, new CAbstractLazyComponent(){

            @Override
            protected CAbstractNodeComponent createComponent() {
                return new CDatabaseNodeComponent(database);
            }
        }, new CDatabaseNodeMenuBuilder(projectTree, parentNode, database), database);
        this.m_database = Preconditions.checkNotNull(database, "IE01962: Database can't be null");
        this.createChildren();
        this.m_listener = new InternalDatabaseListener();
        this.m_database.addListener(this.m_listener);
        ((CDatabaseNodeComponent)this.getComponent()).getPanel().addListener(this.m_panelListener);
    }

    @Override
    protected void createChildren() {
        if (this.m_database.isConnected() && this.m_database.isLoaded()) {
            this.add(new CProjectContainerNode(this.getProjectTree(), this.m_database));
            this.add(new CModuleContainerNode(this.getProjectTree(), this.m_database));
            this.add(new CDebuggerContainerNode(this.getProjectTree(), this.m_database));
            this.add(new CTagContainerNode(this.getProjectTree(), this.m_database));
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        ((CDatabaseNodeComponent)this.getComponent()).getPanel().removeListener(this.m_panelListener);
        this.m_database.removeListener(this.m_listener);
        this.deleteChildren();
    }

    @Override
    public void doubleClicked() {
        if (!(this.m_database.isConnected() || this.m_database.getConfiguration().getIdentity().isEmpty() || this.m_database.getConfiguration().getUser().isEmpty() || this.m_database.getConfiguration().getPassword().isEmpty())) {
            Action action = CActionProxy.proxy(new COpenDatabaseAction(this.getProjectTree(), this.m_database));
            action.actionPerformed(new ActionEvent(this, 0, ""));
        }
    }

    @Override
    public Icon getIcon() {
        return this.m_database.isLoaded() ? ICON_DATABASE_LOADED : ICON_DATABASE_CLOSED;
    }

    @Override
    public String toString() {
        return this.m_database.getConfiguration().getDescription();
    }

    private class InternalDatabaseSettingsPanelListener
    implements IDatabaseSettingsPanelListener {
        private InternalDatabaseSettingsPanelListener() {
        }

        @Override
        public void changedConnectionSettings(CDatabaseSettingsPanel databaseSettingsPanel, boolean changed) {
            ((CDatabaseNodeMenuBuilder)CDatabaseNode.this.getMenuBuilder()).allowConnection(!changed);
        }
    }

    private class InternalDatabaseListener
    extends CDatabaseListenerAdapter {
        private InternalDatabaseListener() {
        }

        @Override
        public void addedProject(IDatabase connection, INaviProject newProject) {
            CDatabaseNode.this.getTreeModel().nodeChanged(CDatabaseNode.this);
        }

        @Override
        public void changedDescription(IDatabase database, String description) {
            CDatabaseNode.this.getTreeModel().nodeChanged(CDatabaseNode.this);
        }

        @Override
        public void closedDatabase(IDatabase connection) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CDatabaseNode.this.deleteChildren();
                    CDatabaseNode.this.getTreeModel().nodeStructureChanged(CDatabaseNode.this);
                }
            }.invokeAndWait();
        }

        @Override
        public void loadedDatabase(IDatabase database) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CDatabaseNode.this.createChildren();
                    CDatabaseNode.this.getTreeModel().nodeStructureChanged(CDatabaseNode.this);
                }
            }.invokeAndWait();
        }
    }
}

