/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.security.zynamics.binnavi.API.helpers.Logger;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CommentDialogs.Interfaces.IComment;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.BaseTypeTableCellRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.TypeInstanceAddressTableCellRenderer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.TypeInstanceCrossReferenceRenderer;
import com.google.security.zynamics.binnavi.ZyGraph.Builders.CommentContainer;
import com.google.security.zynamics.binnavi.disassembly.types.Section;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstance;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceContainer;
import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceReference;
import com.google.security.zynamics.zylib.gui.CodeDisplay.BasicCodeDisplayModel;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplay;
import com.google.security.zynamics.zylib.gui.CodeDisplay.CodeDisplayCoordinate;
import com.google.security.zynamics.zylib.gui.CodeDisplay.FormattedCharacterBuffer;
import com.google.security.zynamics.zylib.gui.CodeDisplay.ICodeDisplayModel;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Color;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;

public class TypeInstanceTableDatamodel
implements ICodeDisplayModel {
    private static final Font HEADER_FONT_BOLD = GuiHelper.MONOSPACED_FONT.deriveFont(1);
    private static final Font STANDARD_FONT = GuiHelper.MONOSPACED_FONT;
    private static final BasicCodeDisplayModel.JCodeDisplayColumnDescription[] columns = new BasicCodeDisplayModel.JCodeDisplayColumnDescription[]{new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Address", 20, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Name", 35, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Type Declaration", 50, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("XRefs", 30, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD), new BasicCodeDisplayModel.JCodeDisplayColumnDescription("Comments", 50, Color.BLACK, Color.LIGHT_GRAY.brighter(), HEADER_FONT_BOLD)};
    static final int ADDRESS_INDEX = 0;
    static final int NAME_INDEX = 1;
    static final int TYPE_INDEX = 2;
    static final int XREFS_INDEX = 3;
    private static final int COMMENTS_INDEX = 4;
    TypeInstanceContainer typeContainer;
    ArrayList<TypeInstance> typesToDisplay = new ArrayList();
    ArrayList<FormattedCharacterBuffer> typeDeclarations = new ArrayList();
    ArrayList<CodeDisplay> displaysToUpdate = new ArrayList();
    Section section;
    int currentNumberOfRows;
    int currentNumberOfLines;

    TypeInstanceTableDatamodel(TypeInstanceContainer instanceContainer, Section currentSection) {
        Preconditions.checkNotNull(currentSection);
        Preconditions.checkNotNull(instanceContainer);
        this.setSection(currentSection);
        this.setTypeInstanceContainer(instanceContainer);
        this.rebuildAndCalculateSize();
    }

    TypeInstanceTableDatamodel() {
        this.rebuildAndCalculateSize();
    }

    private Color getBackgroundColor(int rowIndex, int columnIndex) {
        if (this.displaysToUpdate.size() > 0 && rowIndex == this.displaysToUpdate.get(0).getCaretPosition().getRow()) {
            return columns[columnIndex].getDefaultBackgroundColor().darker();
        }
        return columns[columnIndex].getDefaultBackgroundColor();
    }

    private FormattedCharacterBuffer stringToFormattedCharacterBuffer(String string2, int rowIndex, int columnIndex) {
        return new FormattedCharacterBuffer(Strings.padEnd(string2, columns[columnIndex].getWidth(), ' '), STANDARD_FONT, columns[columnIndex].getDefaultFontColor(), this.getBackgroundColor(rowIndex, columnIndex));
    }

    public void registerCodeDisplayToUpdate(CodeDisplay display) {
        this.displaysToUpdate.add(display);
    }

    public void deRegisterCodeDisplayToUpdate(CodeDisplay display) {
        this.displaysToUpdate.remove(display);
    }

    public void setTypeInstanceContainer(TypeInstanceContainer instanceContainer) {
        this.typeContainer = instanceContainer;
    }

    public TypeInstanceContainer getTypeInstanceContainer() {
        return this.typeContainer;
    }

    public void setSection(Section currentSection) {
        this.section = currentSection;
        this.rebuildAndCalculateSize();
    }

    public TypeInstance getTypeAtRow(int index) {
        return this.typesToDisplay.get(index);
    }

    private void addTypeToDisplay(TypeInstance instance) {
        this.typesToDisplay.add(instance);
        FormattedCharacterBuffer typeRendering = BaseTypeTableCellRenderer.renderType(instance, STANDARD_FONT, columns[2].getWidth(), false);
        this.typeDeclarations.add(typeRendering);
        int typeRenderingHeight = typeRendering.getNumberOfLines();
        int numberOfReferences = this.typeContainer.getReferenceCount(instance);
        this.currentNumberOfLines += Math.max(typeRenderingHeight, numberOfReferences);
    }

    private void rebuildAndCalculateSize() {
        if (this.typeContainer == null) {
            return;
        }
        this.typesToDisplay.clear();
        this.typeDeclarations.clear();
        this.currentNumberOfRows = 0;
        this.currentNumberOfLines = 0;
        for (TypeInstance instance : this.typeContainer.getTypeInstances(this.section)) {
            ++this.currentNumberOfRows;
            this.addTypeToDisplay(instance);
        }
    }

    private static FormattedCharacterBuffer generateFormattedComment(List<IComment> comments) {
        int numberOfRows = 0;
        for (IComment comment : comments) {
            CommentContainer commentContainer = new CommentContainer(comment);
            List<String> commentFragments = commentContainer.getCommentingString();
            numberOfRows += commentFragments.size();
        }
        FormattedCharacterBuffer result = new FormattedCharacterBuffer(numberOfRows + 1, columns[4].getWidth());
        int lineIndex = 0;
        int columnIndex = 0;
        for (IComment comment : comments) {
            CommentContainer commentContainer = new CommentContainer(comment);
            List<String> commentFragments = commentContainer.getCommentingString();
            for (String commentFragment : commentFragments) {
                for (int i2 = 0; i2 < commentFragment.length(); ++i2) {
                    result.setAt(lineIndex, columnIndex, commentFragment.charAt(i2), STANDARD_FONT, Color.BLACK, Color.WHITE);
                    ++columnIndex;
                }
                columnIndex = 0;
                ++lineIndex;
            }
        }
        return result;
    }

    @Override
    public int getNumberOfRows() {
        return this.typesToDisplay.size();
    }

    @Override
    public int getTotalNumberOfLines() {
        return this.currentNumberOfLines;
    }

    @Override
    public int getTotalWidthInCharacters() {
        int total = 0;
        for (int index = 0; index < columns.length; ++index) {
            total += columns[index].getWidth();
        }
        return total;
    }

    @Override
    public int getNumberOfColumns() {
        return columns.length;
    }

    @Override
    public int getColumnWidthInCharacters(int columnIndex) {
        return columns[columnIndex].getWidth();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return columns[columnIndex].getName();
    }

    @Override
    public int getMaximumLinesForRow(int rowIndex) {
        FormattedCharacterBuffer typeRendering = BaseTypeTableCellRenderer.renderType(this.typesToDisplay.get(rowIndex), STANDARD_FONT, columns[2].getWidth(), false);
        return Math.max(typeRendering.getNumberOfLines(), this.typeContainer.getReferenceCount(this.typesToDisplay.get(rowIndex)));
    }

    @Override
    public FormattedCharacterBuffer getLineFormatted(int rowIndex, int columnIndex, int lineIndex) {
        Color backgroundColor = this.getBackgroundColor(rowIndex, columnIndex);
        switch (columnIndex) {
            case 0: {
                TypeInstance type = this.typesToDisplay.get(rowIndex);
                String addressString = "";
                if (lineIndex == 0) {
                    addressString = TypeInstanceAddressTableCellRenderer.getStringToDisplay(false, type.getAddress());
                }
                return this.stringToFormattedCharacterBuffer(addressString, rowIndex, columnIndex);
            }
            case 1: {
                String typeName = "";
                if (lineIndex == 0) {
                    typeName = this.typesToDisplay.get(rowIndex).getName();
                }
                return new FormattedCharacterBuffer(Strings.padEnd(typeName, columns[columnIndex].getWidth(), ' '), STANDARD_FONT, columns[columnIndex].getDefaultFontColor(), backgroundColor);
            }
            case 2: {
                FormattedCharacterBuffer typeDeclaration = this.typeDeclarations.get(rowIndex);
                if (typeDeclaration.getNumberOfLines() > lineIndex) {
                    return this.typeDeclarations.get(rowIndex).getLine(lineIndex).setBackgroundColor(backgroundColor);
                }
                return this.stringToFormattedCharacterBuffer("", rowIndex, columnIndex);
            }
            case 3: {
                TypeInstanceReference reference = this.getTypeInstanceReference(rowIndex, lineIndex);
                String xrefString = "";
                if (reference != null) {
                    xrefString = TypeInstanceCrossReferenceRenderer.renderText(reference);
                }
                return this.stringToFormattedCharacterBuffer(xrefString, rowIndex, columnIndex);
            }
            case 4: {
                FormattedCharacterBuffer comment = TypeInstanceTableDatamodel.generateFormattedComment(this.typeContainer.getComments(this.typesToDisplay.get(rowIndex)));
                if (lineIndex < comment.getNumberOfLines()) {
                    return comment.getLine(lineIndex).setBackgroundColor(backgroundColor);
                }
                return this.stringToFormattedCharacterBuffer("", rowIndex, columnIndex);
            }
        }
        Logger.warning("Invalid column index, investigate.", new Object[0]);
        return null;
    }

    public TypeInstanceReference getTypeInstanceReference(int row, int line) {
        TypeInstance typeInstance = this.typesToDisplay.get(row);
        List<TypeInstanceReference> references = this.typeContainer.getReferences(typeInstance);
        if (line < references.size()) {
            return references.get(line);
        }
        return null;
    }

    @Override
    public boolean canHaveCaret(CodeDisplayCoordinate coordinate) {
        return true;
    }

    @Override
    public boolean isEditable(CodeDisplayCoordinate coordinate) {
        switch (coordinate.getColumn()) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return false;
            }
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void keyPressedOrTyped(CodeDisplayCoordinate coordinate, KeyEvent event) {
        if (!this.isEditable(coordinate)) {
            return;
        }
        if (coordinate.getColumn() != 4 && coordinate.getColumn() == 1 && coordinate.getLine() != 0) {
            switch (event.getKeyCode()) {
                case 0: 
                case 36: {
                    coordinate.setFieldIndex(0);
                    break;
                }
                case 35: {
                    coordinate.setFieldIndex(columns[coordinate.getColumn()].getWidth() - 1);
                    break;
                }
            }
        }
    }

    @Override
    public boolean hasHeaderRow() {
        return true;
    }

    @Override
    public FormattedCharacterBuffer getHeader(int columnIndex) {
        return columns[columnIndex].getHeader();
    }
}

