/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.security.zynamics.binnavi.disassembly.types.TypeInstanceAddress;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class TypeInstanceAddressTableCellRenderer
extends DefaultTableCellRenderer {
    private boolean showvirtualAddress;

    public static String renderText(TypeInstanceAddress address) {
        StringBuilder builder = new StringBuilder(String.format("VA: 0x%X", address.getVirtualAddress()));
        builder.append(String.format("0x%X:%X", address.getBaseAddress().toLong(), address.getOffset()));
        return builder.toString();
    }

    public static String getStringToDisplay(boolean showvirtualAddress, TypeInstanceAddress value) {
        if (showvirtualAddress) {
            return String.format("VA: 0x%X", value.getVirtualAddress());
        }
        return String.format("0x%X:%X", value.getBaseAddress().toLong(), value.getOffset());
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof TypeInstanceAddress) {
            this.setText(TypeInstanceAddressTableCellRenderer.getStringToDisplay(this.showvirtualAddress, (TypeInstanceAddress)value));
            this.setFont(GuiHelper.MONOSPACED_FONT);
            this.setVerticalAlignment(1);
            this.setVerticalTextPosition(1);
        }
        return this;
    }

    public void showVirtualAddress(boolean toggle) {
        this.showvirtualAddress = toggle;
    }
}

