/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.security.zynamics.binnavi.disassembly.types.Section;
import java.awt.Component;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;

public class SectionComboBox
extends JComboBox<Section> {
    public SectionComboBox() {
        this.setRenderer(new SectionComboBoxRenderer());
    }

    public void setSections(List<Section> sections) {
        this.setModel(new SectionComboBoxModel(sections));
    }

    private class SectionComboBoxRenderer
    extends DefaultListCellRenderer {
        private SectionComboBoxRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            Section section = (Section)value;
            if (section != null) {
                this.setText(String.format("%s [0x%X-0x%X]", section.getName(), section.getStartAddress().toLong(), section.getEndAddress().toLong()));
            }
            return this;
        }
    }

    private class SectionComboBoxModel
    extends AbstractListModel<Section>
    implements ComboBoxModel<Section> {
        private final List<Section> sectionsList;
        private Section selectedSection;

        public SectionComboBoxModel(List<Section> sections) {
            this.sectionsList = sections;
            this.selectedSection = sections.get(0);
        }

        @Override
        public Section getElementAt(int index) {
            return this.sectionsList.get(index);
        }

        @Override
        public Object getSelectedItem() {
            return this.selectedSection;
        }

        @Override
        public int getSize() {
            return this.sectionsList.size();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.selectedSection = (Section)anItem;
        }
    }
}

