/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.Navigation;

import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.Navigation.CSearchResult;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.Navigation.CSearchResultModel;
import com.google.security.zynamics.zylib.gui.CHexFormatter;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DefaultFormatterFactory;

class CSearchInputPanel
extends JPanel {
    private final JHexView m_hexView;
    private final CSearchResultModel m_model;
    private final JComboBox<String> m_modeBox = new JComboBox<String>(new String[]{"Text", "Hex"});
    private final JFormattedTextField m_inputField = new JFormattedTextField();

    public CSearchInputPanel(JHexView hexView, CSearchResultModel model) {
        super(new BorderLayout());
        this.m_hexView = hexView;
        this.m_model = model;
        this.m_modeBox.setPreferredSize(new Dimension(150, this.m_modeBox.getMinimumSize().height));
        this.m_inputField.setPreferredSize(new Dimension(150, this.m_inputField.getMinimumSize().height));
        this.m_modeBox.setBorder(new EmptyBorder(0, 0, 0, 5));
        JPanel innerPanel = new JPanel(new BorderLayout());
        innerPanel.add(this.m_modeBox, "West");
        innerPanel.add((Component)this.m_inputField, "East");
        this.add((Component)innerPanel, "West");
        this.m_modeBox.addItemListener(new InternalItemListener());
        this.m_inputField.addActionListener(new InternalActionListener());
    }

    private void search() {
        if (this.m_modeBox.getSelectedIndex() == 0) {
            this.searchText();
        } else {
            this.searchHex();
        }
    }

    private void search(byte[] data) {
        this.m_hexView.uncolorizeAll();
        byte[] hexData = this.m_hexView.getData().getData();
        ArrayList<CSearchResult> results = new ArrayList<CSearchResult>();
        for (int i2 = 0; i2 < hexData.length; ++i2) {
            boolean equal = true;
            int counter = 0;
            for (byte element : data) {
                if (hexData[i2 + counter] != element) {
                    equal = false;
                    break;
                }
                ++counter;
            }
            if (!equal) continue;
            results.add(new CSearchResult(i2, data.length));
        }
        this.m_model.setResults(results);
    }

    private void searchHex() {
        String text2 = this.m_inputField.getText();
        if (text2.length() % 2 != 0) {
            this.m_inputField.setBackground(Color.RED);
            return;
        }
        this.m_inputField.setBackground(Color.WHITE);
        byte[] data = new byte[text2.length() / 2];
        for (int i2 = 0; i2 < text2.length(); i2 += 2) {
            String substr = text2.substring(i2, i2 + 2);
            data[i2 / 2] = (byte)Integer.valueOf(substr, 16).intValue();
        }
        this.search(data);
    }

    private void searchText() {
        this.search(this.m_inputField.getText().getBytes());
    }

    private void updateTextFieldMask() {
        if (this.m_modeBox.getSelectedIndex() == 0) {
            this.m_inputField.setFormatterFactory(new DefaultFormatterFactory());
        } else {
            this.m_inputField.setFormatterFactory(new DefaultFormatterFactory(new CHexFormatter(8)));
        }
    }

    private class InternalItemListener
    implements ItemListener {
        private InternalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            CSearchInputPanel.this.updateTextFieldMask();
        }
    }

    private class InternalActionListener
    extends AbstractAction {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CSearchInputPanel.this.search();
        }
    }
}

