/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.Navigation;

import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.zylib.gui.CHexFormatter;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public final class CGotoPanel
extends JPanel {
    private static final long serialVersionUID = -7910138367100407156L;
    private final JHexView m_hexView;
    private final JFormattedTextField m_addressField = new JFormattedTextField(new CHexFormatter(8)){
        private static final long serialVersionUID = -5688447512051351235L;

        @Override
        protected void processFocusEvent(FocusEvent event) {
            super.processFocusEvent(event);
            if (event.getID() == 1004) {
                this.selectAll();
            }
        }
    };

    public CGotoPanel(JHexView hexView) {
        super(new BorderLayout());
        this.m_hexView = hexView;
        this.setBorder(new TitledBorder("Goto Offset"));
        this.add(this.m_addressField);
        this.m_addressField.addActionListener(new InternalActionListener());
        InputMap inputMap = this.getInputMap(2);
        inputMap.put(HotKeys.GOTO_HK.getKeyStroke(), "focusAction");
        ActionMap actionMap = this.getActionMap();
        actionMap.put("focusAction", new AbstractAction(){
            private static final long serialVersionUID = -5995494363263076534L;

            @Override
            public void actionPerformed(ActionEvent event) {
                CGotoPanel.this.m_addressField.requestFocusInWindow();
            }
        });
    }

    private class InternalActionListener
    extends AbstractAction {
        private static final long serialVersionUID = 2317976040331050206L;

        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                int offset = Integer.valueOf(CGotoPanel.this.m_addressField.getText(), 16);
                if ((long)offset > (long)CGotoPanel.this.m_hexView.getData().getDataLength() + CGotoPanel.this.m_hexView.getBaseAddress() || (long)offset < CGotoPanel.this.m_hexView.getBaseAddress()) {
                    CGotoPanel.this.m_addressField.setBackground(Color.RED);
                } else {
                    CGotoPanel.this.m_hexView.gotoOffset(offset);
                    CGotoPanel.this.m_hexView.requestFocusInWindow();
                    CGotoPanel.this.m_addressField.setBackground(Color.WHITE);
                }
            }
            catch (NumberFormatException exception) {
                CGotoPanel.this.m_addressField.setBackground(Color.RED);
            }
        }
    }
}

