/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.Data.Component.CDataProvider;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.zylib.gui.JHexPanel.JHexView;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public final class CBinaryDataSynchronizer {
    private final JPanel m_hexPanel;
    private final INaviModule m_module;
    private final CDataProvider m_provider;
    private final IModuleListener m_moduleListener = new InternalModuleListener();

    public CBinaryDataSynchronizer(JPanel hexPanel, JHexView hexView, INaviModule module) {
        this.m_hexPanel = Preconditions.checkNotNull(hexPanel, "IE01957: Hex panel argument can not be null");
        Preconditions.checkNotNull(hexView, "IE01958: Hex view argument can not be null");
        this.m_module = Preconditions.checkNotNull(module, "IE01959: Module argument can not be null");
        this.updateBorder();
        this.m_provider = new CDataProvider(module);
        hexView.setData(this.m_provider);
        module.addListener(this.m_moduleListener);
    }

    private void updateBorder() {
        this.m_hexPanel.setBorder(new TitledBorder(String.format("Binary data of '%s'", this.m_module.getConfiguration().getName())));
    }

    public void dispose() {
        this.m_module.removeListener(this.m_moduleListener);
        this.m_provider.dispose();
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void changedName(INaviModule module, String name) {
            CBinaryDataSynchronizer.this.updateBorder();
        }
    }
}

