/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.CTableSearcherHelper;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CFilteredTable;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CProjectTreeTableRenderer;
import com.google.security.zynamics.binnavi.Help.IHelpInformation;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public abstract class CAbstractTreeTable<T>
extends CFilteredTable<T> {
    private final JTree tree;
    private final CAbstractTreeTableModel<T> treeTableModel;
    private final InternalMouseListener mouseListener = new InternalMouseListener();

    public CAbstractTreeTable(JTree projectTree, CAbstractTreeTableModel<T> model, IHelpInformation helpInfo) {
        super(model, helpInfo);
        this.treeTableModel = Preconditions.checkNotNull(model, "IE01939: Model argument can't be null");
        this.tree = Preconditions.checkNotNull(projectTree, "IE02343: Project tree argument can not be null");
        this.addMouseListener(this.mouseListener);
        this.setDefaultRenderer(String.class, new CProjectTreeTableRenderer());
        InputMap windowImap = this.getInputMap(0);
        windowImap.put(HotKeys.SEARCH_HK.getKeyStroke(), "SEARCH");
        this.getActionMap().put("SEARCH", CActionProxy.proxy(new SearchAction()));
        windowImap.put(HotKeys.DELETE_HK.getKeyStroke(), "DELETE");
        this.getActionMap().put("DELETE", CActionProxy.proxy(new DeleteAction()));
        this.updateUI();
    }

    private void displayPopupMenu(MouseEvent event) {
        JPopupMenu popupMenu;
        int selectedIndex = this.getSelectionIndex(event);
        if (selectedIndex != -1 && (popupMenu = this.getPopupMenu(event.getX(), event.getY(), selectedIndex)) != null) {
            popupMenu.show(this, event.getX(), event.getY());
        }
    }

    private int getSelectionIndex(MouseEvent event) {
        return this.convertRowIndexToModel(this.rowAtPoint(event.getPoint()));
    }

    protected void deleteRows() {
    }

    protected JFrame getParentWindow() {
        return (JFrame)SwingUtilities.getWindowAncestor(this.tree);
    }

    protected abstract JPopupMenu getPopupMenu(int var1, int var2, int var3);

    protected JTree getProjectTree() {
        return this.tree;
    }

    protected int[] getSortSelectedRows() {
        int[] rows = this.getSelectedRows();
        for (int i2 = 0; i2 < rows.length; ++i2) {
            rows[i2] = this.convertRowIndexToModel(rows[i2]);
        }
        return rows;
    }

    protected abstract void handleDoubleClick(int var1);

    @Override
    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent event, int condition, boolean pressed) {
        if (event.getKeyCode() == 127) {
            this.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
            boolean retvalue = super.processKeyBinding(keyStroke, event, condition, pressed);
            this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
            return retvalue;
        }
        return super.processKeyBinding(keyStroke, event, condition, pressed);
    }

    @Override
    public void dispose() {
        this.removeMouseListener(this.mouseListener);
        this.treeTableModel.delete();
    }

    @Override
    public CAbstractTreeTableModel<T> getTreeTableModel() {
        return this.treeTableModel;
    }

    private class SearchAction
    extends AbstractAction {
        private SearchAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CTableSearcherHelper.search(SwingUtilities.getWindowAncestor(CAbstractTreeTable.this), CAbstractTreeTable.this);
        }
    }

    private class InternalMouseListener
    extends MouseAdapter {
        private InternalMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 2) {
                CAbstractTreeTable.this.handleDoubleClick(CAbstractTreeTable.this.getSelectionIndex(event));
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CAbstractTreeTable.this.displayPopupMenu(event);
            }
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            if (event.isPopupTrigger()) {
                CAbstractTreeTable.this.displayPopupMenu(event);
            }
        }
    }

    private class DeleteAction
    extends AbstractAction {
        private DeleteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CAbstractTreeTable.this.deleteRows();
        }
    }
}

