/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import java.awt.Window;

public final class CAddressSpaceFunctions {
    private CAddressSpaceFunctions() {
    }

    public static void saveDescription(Window parent, INaviAddressSpace addressSpace, String description) {
        try {
            addressSpace.getConfiguration().setDescription(description);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00154: Could not save address space description";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The new description of the address space '%s' could not be saved.", addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old description."});
            NaviErrorDialog.show(parent, "E00154: Could not save address space description", innerDescription, e2);
        }
    }

    public static void saveName(Window parent, INaviAddressSpace addressSpace, String name) {
        try {
            addressSpace.getConfiguration().setName(name);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00153: Could not save address space name";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The new name of the address space '%s' could not be saved.", addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old name."});
            NaviErrorDialog.show(parent, "E00153: Could not save address space name", innerDescription, e2);
        }
    }
}

