/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.IFilter;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractTreeTableModel;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.comparators.DateComparator;
import com.google.security.zynamics.zylib.general.comparators.IntComparator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;

public final class CProjectModulesModel
extends CAbstractTreeTableModel<INaviModule> {
    private static final long serialVersionUID = -6447001409299309718L;
    private static final int NAME_COLUMN = 0;
    private static final int DESCRIPTION_COLUMN = 1;
    private static final int VIEWS_COLUMN = 2;
    private static final int CREATION_DATE_COLUMN = 3;
    private static final int MODIFICATION_DATE_COLUMN = 4;
    private final String[] COLUMNS = new String[]{"Name", "Description", "Views", "Creation Date", "Modification Date"};
    private final InternalAddressSpaceListener m_addressSpaceListener = new InternalAddressSpaceListener();
    private final InternalModulesListener m_modulesListener = new InternalModulesListener();
    private final INaviAddressSpace m_addressSpace;
    private List<INaviModule> m_cachedValues = null;
    private final IAddressSpaceContentListener m_contentListener = new InternalAddressSpaceContentListener();

    public CProjectModulesModel(INaviAddressSpace addressSpace) {
        Preconditions.checkNotNull(addressSpace, "IE01955: Address space argument can't be null");
        this.m_addressSpace = addressSpace;
        addressSpace.addListener(this.m_addressSpaceListener);
        if (addressSpace.isLoaded()) {
            addressSpace.getContent().addListener(this.m_contentListener);
            for (INaviModule module : addressSpace.getContent().getModules()) {
                module.addListener(this.m_modulesListener);
            }
        }
    }

    @Override
    public void delete() {
        this.m_addressSpace.removeListener(this.m_addressSpaceListener);
        if (this.m_addressSpace.isLoaded()) {
            this.m_addressSpace.getContent().removeListener(this.m_contentListener);
            for (INaviModule module : this.m_addressSpace.getContent().getModules()) {
                module.removeListener(this.m_modulesListener);
            }
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Date.class;
            }
            case 4: {
                return Date.class;
            }
        }
        throw new IllegalArgumentException(String.format("Unexpected column index retrieved while determining column classes: %d", columnIndex));
    }

    @Override
    public int getColumnCount() {
        return this.COLUMNS.length;
    }

    @Override
    public String getColumnName(int index) {
        return this.COLUMNS[index];
    }

    public List<INaviModule> getModules() {
        List<INaviModule> localCachedValues = this.m_cachedValues;
        if (localCachedValues == null) {
            IFilter<INaviModule> filter = this.getFilter();
            localCachedValues = this.m_addressSpace.isLoaded() ? (filter == null ? this.m_addressSpace.getContent().getModules() : filter.get(this.m_addressSpace.getContent().getModules())) : new ArrayList<INaviModule>();
        }
        this.m_cachedValues = localCachedValues;
        return new ArrayList<INaviModule>(localCachedValues);
    }

    @Override
    public int getRowCount() {
        return this.getModules().size();
    }

    @Override
    public List<Pair<Integer, Comparator<?>>> getSorters() {
        ArrayList sorters = new ArrayList();
        sorters.add(new Pair<Integer, IntComparator>(2, new IntComparator()));
        sorters.add(new Pair<Integer, DateComparator>(3, new DateComparator()));
        sorters.add(new Pair<Integer, DateComparator>(4, new DateComparator()));
        return sorters;
    }

    @Override
    public Object getValueAt(int row, int col) {
        INaviModule module = this.getModules().get(row);
        switch (col) {
            case 0: {
                return module.getConfiguration().getName();
            }
            case 1: {
                return module.getConfiguration().getDescription();
            }
            case 2: {
                return module.isLoaded() ? module.getContent().getViewContainer().getViews().size() : module.getCustomViewCount() + module.getFunctionCount() + 1;
            }
            case 3: {
                return module.getConfiguration().getCreationDate();
            }
            case 4: {
                return module.getConfiguration().getModificationDate();
            }
        }
        throw new IllegalStateException("IE01160: Invalid column");
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return col == 0 || col == 1;
    }

    @Override
    public void setFilter(IFilter<INaviModule> filter) {
        this.m_cachedValues = null;
        super.setFilter(filter);
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        if (col != 0 && col != 1) {
            throw new IllegalStateException("IE01161: Column can not be edited");
        }
        INaviModule module = this.getModules().get(row);
        if (col == 0) {
            try {
                module.getConfiguration().setName((String)value);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00156: Could not save address space name";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The new name of the address space '%s' could not be saved.", this.m_addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old name."});
                NaviErrorDialog.show(null, "E00156: Could not save address space name", innerDescription, e2);
            }
        } else if (col == 1) {
            try {
                module.getConfiguration().setDescription((String)value);
            }
            catch (CouldntSaveDataException e3) {
                CUtilityFunctions.logException(e3);
                String innerMessage = "E00157: Could not save address space description";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The new description of the address space '%s' could not be saved.", this.m_addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old description."});
                NaviErrorDialog.show(null, "E00157: Could not save address space description", innerDescription, e3);
            }
        }
    }

    private class InternalModulesListener
    extends CModuleListenerAdapter {
        private InternalModulesListener() {
        }

        @Override
        public void addedView(INaviModule container, INaviView view) {
            CProjectModulesModel.this.m_cachedValues = null;
            CProjectModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedDescription(INaviModule module, String description) {
            CProjectModulesModel.this.m_cachedValues = null;
            CProjectModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedName(INaviModule module, String name) {
            CProjectModulesModel.this.m_cachedValues = null;
            CProjectModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void loadedModule(INaviModule module) {
            CProjectModulesModel.this.m_cachedValues = null;
            CProjectModulesModel.this.fireTableDataChanged();
        }
    }

    private class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void closed(INaviAddressSpace addressSpace, CAddressSpaceContent content) {
            content.removeListener(CProjectModulesModel.this.m_contentListener);
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            addressSpace.getContent().addListener(CProjectModulesModel.this.m_contentListener);
        }
    }

    private class InternalAddressSpaceContentListener
    implements IAddressSpaceContentListener {
        private InternalAddressSpaceContentListener() {
        }

        @Override
        public void addedModule(INaviAddressSpace addressSpace, INaviModule module) {
            CProjectModulesModel.this.m_cachedValues = null;
            module.addListener(CProjectModulesModel.this.m_modulesListener);
            CProjectModulesModel.this.fireTableDataChanged();
        }

        @Override
        public void changedImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress address) {
        }

        @Override
        public void removedModule(INaviAddressSpace addressSpace, INaviModule module) {
            CProjectModulesModel.this.m_cachedValues = null;
            module.removeListener(CProjectModulesModel.this.m_modulesListener);
            CProjectModulesModel.this.fireTableDataChanged();
        }
    }
}

