/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component;

import com.google.security.zynamics.binnavi.Gui.DebuggerComboBox.CDebuggerComboBox;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.CAddressSpaceNodeComponent;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CStandardEditPanel;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfigurationListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceContent;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceConfigurationListener;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceContentListener;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceListener;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.util.Date;
import javax.swing.border.TitledBorder;

public final class CComponentSynchronizer {
    private final CAddressSpaceNodeComponent m_component;
    private final INaviAddressSpace m_addressSpace;
    private final CStandardEditPanel m_stdEditPanel;
    private final CDebuggerComboBox m_debuggerCombo;
    private final TitledBorder m_titledBorder;
    private final IAddressSpaceListener m_addressSpaceListener = new InternalAddressSpaceListener();
    private final IAddressSpaceConfigurationListener m_addressSpaceConfigurationListener = new InternalAddressSpaceConfigurationListener();
    private final IAddressSpaceContentListener m_addressSpaceContentListener = new InternalAddressSpaceContentListener();

    public CComponentSynchronizer(CAddressSpaceNodeComponent component, INaviAddressSpace addressSpace, CStandardEditPanel stdEditPanel, CDebuggerComboBox debuggerCombo, TitledBorder titledBorder) {
        this.m_component = component;
        this.m_addressSpace = addressSpace;
        this.m_stdEditPanel = stdEditPanel;
        this.m_debuggerCombo = debuggerCombo;
        this.m_titledBorder = titledBorder;
        addressSpace.addListener(this.m_addressSpaceListener);
        addressSpace.getConfiguration().addListener(this.m_addressSpaceConfigurationListener);
        if (addressSpace.isLoaded()) {
            addressSpace.getContent().addListener(this.m_addressSpaceContentListener);
        }
        this.m_titledBorder.setTitle(this.getBorderText());
    }

    private String getBorderText() {
        return String.format("%d Modules in Address Space '%s'", this.m_addressSpace.getModuleCount(), this.m_addressSpace.getConfiguration().getName());
    }

    public void dispose() {
        if (this.m_addressSpace.isLoaded()) {
            this.m_addressSpace.getContent().removeListener(this.m_addressSpaceContentListener);
        }
        this.m_addressSpace.removeListener(this.m_addressSpaceListener);
        this.m_addressSpace.getConfiguration().removeListener(this.m_addressSpaceConfigurationListener);
    }

    private final class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void closed(INaviAddressSpace addressSpace, CAddressSpaceContent content) {
            content.removeListener(CComponentSynchronizer.this.m_addressSpaceContentListener);
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            addressSpace.getContent().addListener(CComponentSynchronizer.this.m_addressSpaceContentListener);
        }
    }

    private final class InternalAddressSpaceContentListener
    implements IAddressSpaceContentListener {
        private InternalAddressSpaceContentListener() {
        }

        @Override
        public void addedModule(INaviAddressSpace addressSpace, INaviModule module) {
            CComponentSynchronizer.this.m_titledBorder.setTitle(CComponentSynchronizer.this.getBorderText());
            CComponentSynchronizer.this.m_component.updateUI();
        }

        @Override
        public void changedImageBase(INaviAddressSpace addressSpace, INaviModule module, IAddress address) {
        }

        @Override
        public void removedModule(INaviAddressSpace addressSpace, INaviModule module) {
            CComponentSynchronizer.this.m_titledBorder.setTitle(CComponentSynchronizer.this.getBorderText());
            CComponentSynchronizer.this.m_component.updateUI();
        }
    }

    private class InternalAddressSpaceConfigurationListener
    extends CAddressSpaceConfigurationListenerAdapter {
        private InternalAddressSpaceConfigurationListener() {
        }

        @Override
        public void changedDebugger(INaviAddressSpace addressSpace, DebuggerTemplate debugger) {
            CComponentSynchronizer.this.m_debuggerCombo.setSelectedDebugger(debugger);
        }

        @Override
        public void changedDescription(INaviAddressSpace addressSpace, final String description) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CComponentSynchronizer.this.m_stdEditPanel.setDescription(description);
                }
            }.invokeLater();
        }

        @Override
        public void changedModificationDate(CAddressSpace addressSpace, final Date date) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CComponentSynchronizer.this.m_stdEditPanel.setModificationDate(date);
                }
            }.invokeLater();
        }

        @Override
        public void changedName(INaviAddressSpace addressSpace, final String name) {
            new SwingInvoker(){

                @Override
                protected void operation() {
                    CComponentSynchronizer.this.m_stdEditPanel.setNameString(name);
                }
            }.invokeLater();
        }
    }
}

