/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.DebuggerComboBox.CDebuggerComboBox;
import com.google.security.zynamics.binnavi.Gui.DebuggerComboBox.CDebuggerComboModel;
import com.google.security.zynamics.binnavi.Gui.FilterPanel.CTablePanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.CComponentSynchronizer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.CProjectDebuggerContainer;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.CProjectModulesTable;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CCreationDateHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CDescriptionHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CModificationDateHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CModuleFilterHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CNameHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Help.CSaveHelp;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace.Component.Implementations.CAddressSpaceFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractNodeComponent;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.filters.CModuleFilterCreator;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CDefaultFieldDescription;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.CStandardEditPanel;
import com.google.security.zynamics.binnavi.Gui.StandardEditPanel.IInputPanelListener;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Help.CHelpButton;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CAddressSpaceNodeComponent
extends CAbstractNodeComponent {
    private static final long serialVersionUID = -6284210238971673084L;
    private final INaviAddressSpace m_addressSpace;
    private final TitledBorder m_titledBorder;
    private final CStandardEditPanel m_stdEditPanel;
    private CDebuggerComboBox m_debuggerCombo;
    private final CProjectModulesTable m_table;
    private final JButton m_saveButton = new CHelpButton(CActionProxy.proxy(new SaveAction()), new CSaveHelp());
    private final CProjectDebuggerContainer m_debuggerContainer;
    private final UpdateListener m_updateListener = new UpdateListener();
    private final CComponentSynchronizer m_synchronizer;

    public CAddressSpaceNodeComponent(JTree projectTree, IDatabase database, INaviProject project, INaviAddressSpace addressSpace) {
        super(new BorderLayout());
        Preconditions.checkNotNull(database, "IE01948: Database argument can not be null");
        Preconditions.checkNotNull(project, "IE01949: Project argument can't be null");
        Preconditions.checkNotNull(addressSpace, "IE01950: Address space argument can't be null");
        Preconditions.checkArgument(database.inSameDatabase(project), "IE01951: The project is not in the given database");
        Preconditions.checkArgument(database.inSameDatabase(addressSpace), "IE01952: The address space is not in the given database");
        Preconditions.checkArgument(project.getContent().getAddressSpaces().contains(addressSpace), "IE01953: Address space does not belong to the given project");
        this.m_addressSpace = addressSpace;
        this.m_table = new CProjectModulesTable(projectTree, database, addressSpace);
        CDefaultFieldDescription<String> nameInfo = new CDefaultFieldDescription<String>(addressSpace.getConfiguration().getName(), new CNameHelp());
        CDefaultFieldDescription<String> descriptionInfo = new CDefaultFieldDescription<String>(addressSpace.getConfiguration().getDescription(), new CDescriptionHelp());
        CDefaultFieldDescription<Date> creationInfo = new CDefaultFieldDescription<Date>(addressSpace.getConfiguration().getCreationDate(), new CCreationDateHelp());
        CDefaultFieldDescription<Date> modificationInfo = new CDefaultFieldDescription<Date>(addressSpace.getConfiguration().getModificationDate(), new CModificationDateHelp());
        this.m_stdEditPanel = new CStandardEditPanel("Address Space", nameInfo, descriptionInfo, creationInfo, modificationInfo);
        this.m_debuggerContainer = new CProjectDebuggerContainer(project);
        this.m_titledBorder = new TitledBorder("");
        this.createGui();
        this.m_synchronizer = new CComponentSynchronizer(this, addressSpace, this.m_stdEditPanel, this.m_debuggerCombo, this.m_titledBorder);
        this.updateSaveButton();
        this.m_stdEditPanel.addInputListener(this.m_updateListener);
        this.m_debuggerCombo.addActionListener(this.m_updateListener);
    }

    private void createGui() {
        JPanel topPanel = new JPanel(new BorderLayout());
        JPanel innerTopPanel = new JPanel(new BorderLayout());
        JPanel debuggerChooserPanel = new JPanel(new BorderLayout());
        debuggerChooserPanel.setBorder(new TitledBorder("Address Space Debugger"));
        this.m_debuggerCombo = new CDebuggerComboBox(new CDebuggerComboModel(this.m_debuggerContainer));
        this.m_debuggerCombo.setSelectedDebugger(this.m_addressSpace.getConfiguration().getDebuggerTemplate());
        JPanel debuggerComboPanel = new JPanel(new BorderLayout());
        debuggerComboPanel.add((Component)this.m_debuggerCombo, "Center");
        debuggerChooserPanel.add((Component)debuggerComboPanel, "Center");
        innerTopPanel.add(this.m_stdEditPanel);
        innerTopPanel.add((Component)debuggerChooserPanel, "South");
        topPanel.add(innerTopPanel);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 2));
        buttonPanel.setBorder(new EmptyBorder(0, 0, 5, 2));
        buttonPanel.add(new JPanel());
        buttonPanel.add(this.m_saveButton);
        topPanel.add((Component)buttonPanel, "South");
        CTablePanel<INaviModule> bottomPanel = new CTablePanel<INaviModule>(this.m_table, new CModuleFilterCreator(), new CModuleFilterHelp());
        bottomPanel.setBorder(this.m_titledBorder);
        bottomPanel.add(new JScrollPane(this.m_table));
        JSplitPane splitPane = new JSplitPane(0, true, topPanel, bottomPanel);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(splitPane.getMinimumDividerLocation());
        splitPane.setResizeWeight(0.5);
        this.setBorder(new EmptyBorder(0, 0, 0, 1));
        this.add(splitPane);
    }

    private void save() {
        new Thread(){

            @Override
            public void run() {
                CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                operation.getProgressPanel().setMaximum(3);
                operation.getProgressPanel().setText("Saving address space configuration: Saving Name");
                CAddressSpaceFunctions.saveName(SwingUtilities.getWindowAncestor(CAddressSpaceNodeComponent.this), CAddressSpaceNodeComponent.this.m_addressSpace, CAddressSpaceNodeComponent.this.m_stdEditPanel.getNameString());
                operation.getProgressPanel().next();
                operation.getProgressPanel().setText("Saving address space configuration: Saving Description");
                CAddressSpaceFunctions.saveDescription(SwingUtilities.getWindowAncestor(CAddressSpaceNodeComponent.this), CAddressSpaceNodeComponent.this.m_addressSpace, CAddressSpaceNodeComponent.this.m_stdEditPanel.getDescription());
                operation.getProgressPanel().next();
                operation.getProgressPanel().setText("Saving address space configuration: Saving Debugger");
                CAddressSpaceNodeComponent.this.saveDebugger();
                operation.getProgressPanel().next();
                operation.stop();
                CAddressSpaceNodeComponent.this.updateSaveButton();
            }
        }.start();
    }

    private void saveDebugger() {
        try {
            this.m_addressSpace.getConfiguration().setDebuggerTemplate(this.m_debuggerCombo.getSelectedDebugger());
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00155: Could not save address space debugger";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The new debugger of the address space '%s' could not be saved.", this.m_addressSpace.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The address space keeps its old debugger."});
            NaviErrorDialog.show(SwingUtilities.getWindowAncestor(this), "E00155: Could not save address space debugger", innerDescription, e2);
        }
    }

    private void updateSaveButton() {
        this.m_saveButton.setEnabled(!this.m_stdEditPanel.getNameString().equals(this.m_addressSpace.getConfiguration().getName()) || !this.m_stdEditPanel.getDescription().equals(this.m_addressSpace.getConfiguration().getDescription()) || this.m_debuggerCombo.getSelectedDebugger() != this.m_addressSpace.getConfiguration().getDebuggerTemplate());
    }

    @Override
    public void dispose() {
        this.m_synchronizer.dispose();
        this.m_debuggerContainer.dispose();
        this.m_table.dispose();
    }

    private class UpdateListener
    implements ActionListener,
    IInputPanelListener {
        private UpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CAddressSpaceNodeComponent.this.updateSaveButton();
        }

        @Override
        public void changedInput() {
            CAddressSpaceNodeComponent.this.updateSaveButton();
        }
    }

    private final class SaveAction
    extends AbstractAction {
        private static final long serialVersionUID = -2453848241255126009L;

        private SaveAction() {
            super("Save");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            CAddressSpaceNodeComponent.this.save();
        }
    }
}

