/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.AddressSpace;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.API.disassembly.AddressSpace;
import com.google.security.zynamics.binnavi.API.disassembly.Database;
import com.google.security.zynamics.binnavi.API.disassembly.DatabaseManager;
import com.google.security.zynamics.binnavi.API.disassembly.Project;
import com.google.security.zynamics.binnavi.API.plugins.IAddressSpaceMenuPlugin;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.APIHelpers.ObjectFinders;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.Actions.CActionProxy;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CCreateCombinedCallgraphAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CDeleteAddressSpaceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CLoadAddressSpaceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CResolveAllFunctionsSingleAddressSpaceAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions.CSearchTableAction;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.CAbstractMenuBuilder;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CEmptyUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.CParentSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.tables.CopySelectionAction;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public final class CAddressSpaceNodeMenuBuilder
extends CAbstractMenuBuilder {
    private final DefaultMutableTreeNode m_parentNode;
    private final JTable m_table;
    private final IDatabase m_database;
    private final INaviProject m_project;
    private final INaviAddressSpace[] m_addressSpaces;
    private final IViewContainer m_container;
    private final Action m_loadAddressSpaceAction;
    private final InternalAddressSpaceListener m_listener = new InternalAddressSpaceListener();

    public CAddressSpaceNodeMenuBuilder(JTree projectTree, DefaultMutableTreeNode parentNode, JTable table, IDatabase database, INaviProject project, INaviAddressSpace[] addressSpaces, IViewContainer container) {
        super(projectTree);
        Preconditions.checkNotNull(projectTree, "IE01943: Project tree argument can not be null");
        this.m_database = Preconditions.checkNotNull(database, "IE01944: Database argument can not be null");
        this.m_project = Preconditions.checkNotNull(project, "IE01945: Project argument can't be null");
        Preconditions.checkNotNull(addressSpaces, "IE01946: Address space argument can't be null");
        for (INaviAddressSpace addressSpace : addressSpaces) {
            Preconditions.checkNotNull(addressSpace, "IE01947: Address spaces list contains a null-element");
        }
        this.m_parentNode = parentNode;
        this.m_addressSpaces = (INaviAddressSpace[])addressSpaces.clone();
        this.m_table = table;
        this.m_container = container;
        this.m_loadAddressSpaceAction = CActionProxy.proxy(new CLoadAddressSpaceAction(projectTree, this.m_addressSpaces));
        if (addressSpaces.length == 1) {
            this.updateActions(this.m_addressSpaces[0]);
            this.m_addressSpaces[0].addListener(this.m_listener);
        }
    }

    private void addPluginMenu(JComponent menu, IAddressSpaceMenuPlugin plugin) {
        try {
            List<JComponent> menuItems = plugin.extendAddressSpaceMenu(this.getPluginAddressSpaces());
            if (menuItems != null) {
                for (JComponent menuItem : menuItems) {
                    if (menuItem == null) continue;
                    menu.add(menuItem);
                }
            }
        }
        catch (Exception exception) {
            CUtilityFunctions.logException(exception);
            String innerMessage = "E00094: Plugin caused an unexpected exception";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The plugin %s caused an unexpected exception.", plugin.getName()), new String[]{"The plugin contains a bug."}, new String[]{"The plugin probably behaves erroneously from this point on but it remains active"});
            NaviErrorDialog.show(this.getParent(), "E00094: Plugin caused an unexpected exception", innerDescription, exception);
        }
    }

    private void addPluginMenus(JComponent menu) {
        ArrayList<IAddressSpaceMenuPlugin> plugins = Lists.newArrayList();
        for (IAddressSpaceMenuPlugin plugin : PluginInterface.instance().getPluginRegistry()) {
            if (!(plugin instanceof IAddressSpaceMenuPlugin)) continue;
            plugins.add(plugin);
        }
        if (!plugins.isEmpty()) {
            menu.add(new JSeparator());
            for (IAddressSpaceMenuPlugin plugin : plugins) {
                this.addPluginMenu(menu, plugin);
            }
        }
    }

    private ITreeUpdater getParentUpdater() {
        return this.m_parentNode == null ? new CEmptyUpdater() : new CParentSelectionUpdater(this.getProjectTree(), this.m_parentNode);
    }

    private List<AddressSpace> getPluginAddressSpaces() {
        DatabaseManager manager = PluginInterface.instance().getDatabaseManager();
        for (Database database : manager) {
            if (database.getNative() != this.m_database) continue;
            for (Project project : database.getProjects()) {
                if (project.getNative() != this.m_project) continue;
                List<AddressSpace> allSpaces = project.getAddressSpaces();
                ArrayList<AddressSpace> menuSpaces = new ArrayList<AddressSpace>();
                for (INaviAddressSpace addressSpace : this.m_addressSpaces) {
                    menuSpaces.add(ObjectFinders.getObject(addressSpace, allSpaces));
                }
                return menuSpaces;
            }
        }
        throw new IllegalStateException("IE01159: Unknown database");
    }

    private void updateActions(INaviAddressSpace addressSpace) {
        this.m_loadAddressSpaceAction.setEnabled(!addressSpace.isLoaded());
    }

    @Override
    protected void createMenu(JComponent menu) {
        menu.add(new JMenuItem(this.m_loadAddressSpaceAction));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(CActionProxy.proxy(new CDeleteAddressSpaceAction(this.getParent(), this.m_project, this.m_addressSpaces, this.getParentUpdater()))));
        if (this.m_addressSpaces.length == 1) {
            menu.add(new JSeparator());
            menu.add(new JMenuItem(CActionProxy.proxy(new CCreateCombinedCallgraphAction(this.getParent(), this.m_container, this.m_project, this.m_addressSpaces[0]))));
            menu.add(new JSeparator());
            menu.add(new JMenuItem(CActionProxy.proxy(new CResolveAllFunctionsSingleAddressSpaceAction(menu, this.m_database, this.m_addressSpaces[0]))));
        }
        if (this.m_table != null) {
            menu.add(new JSeparator());
            menu.add(new JMenuItem(CActionProxy.proxy(new CSearchTableAction(this.getParent(), this.m_table))));
            menu.add(new JMenuItem(CActionProxy.proxy(new CopySelectionAction(this.m_table))));
        }
        this.addPluginMenus(menu);
    }

    @Override
    protected JMenu getMenu() {
        JMenu menu = new JMenu("Address Space");
        menu.setMnemonic("HK_MENU_ADDRESS_SPACE".charAt(0));
        return menu;
    }

    @Override
    public void dispose() {
        if (this.m_addressSpaces.length == 1) {
            this.m_addressSpaces[0].removeListener(this.m_listener);
        }
    }

    private class InternalAddressSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalAddressSpaceListener() {
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            CAddressSpaceNodeMenuBuilder.this.updateActions(addressSpace);
        }
    }
}

