/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.disassembly.views.CView;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.List;

public final class CViewTransferable
implements Transferable {
    private static final DataFlavor[] SUPPORTED_FLAVORS = new DataFlavor[1];
    public static final DataFlavor VIEW_FLAVOR;
    private final List<INaviView> m_views;

    public CViewTransferable(List<INaviView> views) {
        Preconditions.checkNotNull(views, "IE01937: Views argument can't be null");
        this.m_views = new ArrayList<INaviView>(views);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (flavor.equals(VIEW_FLAVOR)) {
            return new ArrayList<INaviView>(this.m_views);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])SUPPORTED_FLAVORS.clone();
    }

    public List<INaviView> getViews() {
        return new ArrayList<INaviView>(this.m_views);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor.equals(VIEW_FLAVOR);
    }

    static {
        CViewTransferable.SUPPORTED_FLAVORS[0] = VIEW_FLAVOR = new DataFlavor(CView.class, "BinNavi Views");
    }
}

