/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.DragAndDrop;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.DragAndDrop.IDropHandler;
import com.google.security.zynamics.zylib.gui.dndtree.DNDTree;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public abstract class CAbstractDropHandler
implements IDropHandler {
    private final DataFlavor m_flavor;

    protected CAbstractDropHandler(DataFlavor flavor) {
        this.m_flavor = Preconditions.checkNotNull(flavor, "IE01925: Flavor argument can not be null");
    }

    private Object getData(Transferable transferable) {
        try {
            return transferable.getTransferData(this.m_flavor);
        }
        catch (UnsupportedFlavorException | IOException exception) {
            CUtilityFunctions.logException(exception);
            return null;
        }
    }

    protected abstract boolean canHandle(DefaultMutableTreeNode var1, Object var2);

    protected abstract void drop(DefaultMutableTreeNode var1, Object var2);

    @Override
    public boolean canHandle(DNDTree target, Transferable transferable, DataFlavor flavor, int x2, int y2) {
        if (!transferable.isDataFlavorSupported(this.m_flavor)) {
            return false;
        }
        Object data = this.getData(transferable);
        if (data == null) {
            return false;
        }
        TreePath pathTarget = target.getPathForLocation(x2, y2);
        if (pathTarget == null) {
            target.setSelectionPath(null);
            return false;
        }
        return this.canHandle((DefaultMutableTreeNode)pathTarget.getLastPathComponent(), data);
    }

    @Override
    public void drop(Transferable transferable, DefaultMutableTreeNode parentNode) {
        if (!transferable.isDataFlavorSupported(this.m_flavor)) {
            return;
        }
        Object data = this.getData(transferable);
        if (data == null) {
            return;
        }
        this.drop(parentNode, data);
    }
}

