/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CViewSearcher;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public final class CSearchAction
extends AbstractAction {
    private static final long serialVersionUID = -6782301260180411109L;
    private final Window m_parent;
    private final JComponent m_parentComponent;
    private final IViewContainer m_container;
    private IAddress m_address;

    public CSearchAction(JComponent parent, IViewContainer container) {
        super("Search View");
        CSearchAction.checkArguments(parent);
        this.m_container = Preconditions.checkNotNull(container, "IE01149: Project argument can not be null");
        this.m_parent = null;
        this.m_parentComponent = parent;
        this.putValue("MnemonicKey", "HK_MENU_SEARCH_VIEW".charAt(0));
    }

    public CSearchAction(Window parent, IViewContainer container, IAddress address) {
        super("Search View");
        CSearchAction.checkArguments(parent);
        Preconditions.checkNotNull(container, "IE01918: Container argument can not be null");
        this.m_parent = parent;
        this.m_parentComponent = null;
        this.m_container = container;
        this.m_address = address;
        this.putValue("MnemonicKey", "HK_MENU_SEARCH_VIEW".charAt(0));
    }

    private static void checkArguments(Object parent) {
        Preconditions.checkNotNull(parent, "IE01920: Parent argument can not be null");
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Window parent = this.m_parent == null ? SwingUtilities.getWindowAncestor(this.m_parentComponent) : this.m_parent;
        CViewSearcher.searchView(parent, this.m_container, this.m_address);
    }
}

