/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CModuleInitializationFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;

public class CModuleInitializeAction
extends AbstractAction {
    private final JTree m_projectTree;
    private final INaviModule[] m_modules;

    public CModuleInitializeAction(JTree projectTree, INaviModule[] modules) {
        super(CModuleInitializeAction.generateMenuEntryName(modules));
        this.m_projectTree = Preconditions.checkNotNull(projectTree, "IE01901: Project tree argument can not be null");
        this.m_modules = (INaviModule[])Preconditions.checkNotNull(modules, "IE01902: Module argument can't be null").clone();
        this.putValue("AcceleratorKey", HotKeys.INITIALIZE_MODULE_ACCELERATOR_KEY.getKeyStroke());
        this.putValue("MnemonicKey", "HK_MENU_INITIALIZE_MODULE".charAt(0));
    }

    private static String generateMenuEntryName(INaviModule[] modules) {
        Preconditions.checkNotNull(modules, "IE00733: modules argument can not be null");
        if (modules.length == 1) {
            return "Initialize Module";
        }
        return "Initialize Modules";
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        for (INaviModule module : this.m_modules) {
            CModuleInitializationFunctions.initializeModule(this.m_projectTree, module);
        }
    }
}

