/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CProjectFunctions;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTree;

public final class CLoadProjectAction
extends AbstractAction {
    private static final long serialVersionUID = 3164027319049009140L;
    private final JTree m_projectTree;
    private final INaviProject[] m_projects;

    public CLoadProjectAction(JTree projectTree, INaviProject[] projects) {
        super("Load Project");
        this.m_projectTree = Preconditions.checkNotNull(projectTree, "IE01904: Project tree argument can not be null");
        this.m_projects = (INaviProject[])Preconditions.checkNotNull(projects, "IE01905: Projects argument can't be null").clone();
        for (INaviProject project : projects) {
            Preconditions.checkNotNull(project, "IE01906: Projects list contains a null-element");
        }
        this.putValue("AcceleratorKey", HotKeys.LOAD_HK.getKeyStroke());
        this.putValue("MnemonicKey", "HK_MENU_LOAD_PROJECT".charAt(0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CProjectFunctions.openProjects(this.m_projectTree, this.m_projects);
    }
}

