/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Actions;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.HotKeys;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CDatabaseFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public final class CDeleteProjectAction
extends AbstractAction {
    private static final long serialVersionUID = 5311924222270401955L;
    private final JFrame m_parent;
    private final IDatabase m_database;
    private final INaviProject[] m_projects;
    private final ITreeUpdater m_updater;

    public CDeleteProjectAction(JFrame parent, IDatabase database, INaviProject[] projects, ITreeUpdater updater) {
        super("Delete Project");
        this.m_parent = Preconditions.checkNotNull(parent, "IE01882: Parent argument can't be null");
        this.m_database = Preconditions.checkNotNull(database, "IE01883: Database argument can't be null");
        this.m_projects = (INaviProject[])Preconditions.checkNotNull(projects, "IE01884: Projects argument can't be null").clone();
        this.m_updater = Preconditions.checkNotNull(updater, "IE02339: updater argument can not be null");
        for (INaviProject project : projects) {
            Preconditions.checkNotNull(project, "IE01885: Projects list contains a null-element");
        }
        this.putValue("AcceleratorKey", HotKeys.DELETE_HK.getKeyStroke());
        this.putValue("MnemonicKey", "HK_MENU_DELETE_PROJECT".charAt(0));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        CDatabaseFunctions.deleteProjects(this.m_parent, this.m_database, this.m_projects, this.m_updater);
    }
}

