/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Gui.Scripting.CScriptingDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Help.CHelpManager;
import com.google.security.zynamics.binnavi.Resources.Constants;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.gui.CDialogAboutEx;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.gui.license.UpdateCheckHelper;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.Image;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public final class CWindowFunctions {
    private static final String MANUAL_FILE = "src/main/java/com/google/security/zynamics/binnavi/manual/index.htm";

    private CWindowFunctions() {
    }

    public static void checkForUpdates(JFrame parent) {
        UpdateCheckHelper.checkForUpdatesWithUi(parent, "BinNavi", "6.0.1");
    }

    public static void showAboutDialog(JFrame parent) {
        try {
            ArrayList<Pair<String, URL>> urls = new ArrayList<Pair<String, URL>>();
            urls.add(new Pair<String, URL>("zynamics Website", new URL("http://www.zynamics.com")));
            urls.add(new Pair<String, URL>("BinNavi Product Site", new URL("http://www.zynamics.com/binnavi.html")));
            urls.add(new Pair<String, URL>("Report Bugs", new URL("mailto:zynamics-support@google.com")));
            String message2 = String.valueOf(Constants.PROJECT_NAME_VERSION_BUILD).concat("\n\nCopyright \u00a92004-2011 zynamics GmbH.\nCopyright \u00a92011-2016 Google Inc.\n");
            String description = "\nParts of this software were created by third parties and have different licensing requirements.\nPlease see the manual file for a complete list.\n";
            Image appImage = new ImageIcon(CMain.class.getResource("data/binnavi_logo3_border.png")).getImage();
            CDialogAboutEx dlg = new CDialogAboutEx(parent, new ImageIcon(appImage), "BinNavi 6.1", message2, "\nParts of this software were created by third parties and have different licensing requirements.\nPlease see the manual file for a complete list.\n", urls);
            GuiHelper.centerOnScreen(dlg);
            dlg.setVisible(true);
        }
        catch (Exception e2) {
            CUtilityFunctions.logException(e2);
        }
    }

    public static void showContextHelp(JFrame window) {
        CHelpManager.instance().start(window);
    }

    public static void showHelpFile(JFrame parent) {
        try {
            Desktop.getDesktop().open(new File(MANUAL_FILE));
        }
        catch (Exception e2) {
            CUtilityFunctions.logException(e2);
            String message2 = "E00198: Could not open help file";
            String description = CUtilityFunctions.createDescription(String.format("The help file '%s' could not be opened.", MANUAL_FILE), new String[]{"The manual file was accidentaly deleted."}, new String[]{"BinNavi could not open the help file. Please try to open the help file manually."});
            NaviErrorDialog.show(parent, "E00198: Could not open help file", description, e2);
        }
    }

    public static void showScriptingDialog(JFrame parent) {
        String defaultLanguage = ConfigManager.instance().getGeneralSettings().getDefaultScriptingLanguage();
        CScriptingDialog dlg = new CScriptingDialog((Frame)parent, defaultLanguage, PluginInterface.instance());
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
        GuiHelper.applyWindowFix(dlg);
    }
}

