/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.Tagging.CTag;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.awt.Window;
import javax.swing.JFrame;

public final class CViewFunctions {
    private CViewFunctions() {
    }

    public static void removeTags(INaviView[] views, CTag tag) {
        for (INaviView view : views) {
            try {
                view.getConfiguration().untagView(tag);
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }

    public static void renameBack(Window parent, INaviView view, String originalName) {
        try {
            view.getConfiguration().setName(originalName);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00063: View name could not be changed";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The view name of view '%s' could not be changed.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view was not updated and the new view name is lost."});
            NaviErrorDialog.show(parent, "E00063: View name could not be changed", innerDescription, e2);
        }
    }

    public static void star(Window parent, INaviView[] views) {
        for (INaviView view : views) {
            try {
                view.getConfiguration().setStared(true);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00090: View could not be stared";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be stared.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view star was not updated."});
                NaviErrorDialog.show(parent, "E00090: View could not be stared", innerDescription, e2);
            }
        }
    }

    public static void tagView(JFrame parent, INaviView view, CTag tag) {
        try {
            view.getConfiguration().tagView(tag);
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00149: Could not tag view";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be tagged.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view remains untagged."});
            NaviErrorDialog.show(parent, "E00149: Could not tag view", innerDescription, e2);
        }
    }

    public static void toggleStars(Window parent, INaviView[] views) {
        for (INaviView view : views) {
            try {
                view.getConfiguration().setStared(!view.getConfiguration().isStared());
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00142: View star could not be toggled";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The star state of view '%s' could not be toggled.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view star was not updated."});
                NaviErrorDialog.show(parent, "E00142: View star could not be toggled", innerDescription, e2);
            }
        }
    }

    public static void unstar(Window parent, INaviView[] views) {
        for (INaviView view : views) {
            try {
                view.getConfiguration().setStared(false);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00176: View could not be unstared";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The view '%s' could not be unstared.", view.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The view star was not updated."});
                NaviErrorDialog.show(parent, "E00176: View could not be unstared", innerDescription, e2);
            }
        }
    }
}

