/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.debug.models.trace.TraceList;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import java.util.List;

public final class CNameListGenerators {
    private static final int MAX_LIST_LENGTH = 10;

    private CNameListGenerators() {
    }

    public static String getNameList(DebuggerTemplate[] debuggers) {
        int count = 0;
        StringBuilder list = new StringBuilder();
        for (DebuggerTemplate debugger : debuggers) {
            list.append("- ");
            list.append(debugger.getName());
            list.append('\n');
            if (++count != 10 || debuggers.length == 10) continue;
            list.append("\n... ");
            list.append(String.format("%d others ...", debuggers.length - count));
            break;
        }
        return list.toString();
    }

    public static String getNameList(INaviAddressSpace[] addressSpaces) {
        int count = 0;
        StringBuilder list = new StringBuilder();
        for (INaviAddressSpace addressSpace : addressSpaces) {
            list.append("- ");
            list.append(addressSpace.getConfiguration().getName());
            list.append('\n');
            if (++count != 10 || addressSpaces.length == 10) continue;
            list.append("\n... ");
            list.append(String.format("%d others ...", addressSpaces.length - count));
            break;
        }
        return list.toString();
    }

    public static String getNameList(INaviModule[] modules) {
        int count = 0;
        StringBuilder list = new StringBuilder();
        for (INaviModule module : modules) {
            list.append("- ");
            list.append(module.getConfiguration().getName());
            list.append('\n');
            if (++count != 10 || modules.length == 10) continue;
            list.append("\n... ");
            list.append(String.format("%d others ...", modules.length - count));
            break;
        }
        return list.toString();
    }

    public static String getNameList(INaviProject[] projects) {
        int count = 0;
        StringBuilder list = new StringBuilder();
        for (INaviProject project : projects) {
            list.append("- ");
            list.append(project.getConfiguration().getName());
            list.append('\n');
            if (++count != 10 || projects.length == 10) continue;
            list.append("\n... ");
            list.append(String.format("%d others ...", projects.length - count));
            break;
        }
        return list.toString();
    }

    public static String getNameList(INaviView[] views) {
        int count = 0;
        StringBuilder list = new StringBuilder();
        for (INaviView view : views) {
            list.append("- ");
            list.append(view.getName());
            list.append('\n');
            if (++count != 10 || views.length == 10) continue;
            list.append("\n... ");
            list.append(String.format("%d others ...", views.length - count));
            break;
        }
        return list.toString();
    }

    public static String getNameList(List<TraceList> traces) {
        int count = 0;
        StringBuilder list = new StringBuilder();
        for (TraceList trace2 : traces) {
            list.append("- ");
            list.append(trace2.getName());
            list.append('\n');
            if (++count != 10 || traces.size() == 10) continue;
            list.append("\n... ");
            list.append(String.format("%d others ...", traces.size() - count));
            break;
        }
        return list.toString();
    }
}

