/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import javax.swing.JFrame;

public final class CModuleStaringFunctions {
    private CModuleStaringFunctions() {
    }

    public static void star(JFrame parent, INaviModule[] modules) {
        for (INaviModule module : modules) {
            try {
                module.getConfiguration().setStared(true);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00062: Module could not be stared";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The module '%s' could not be stared.", module.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The module star was not updated."});
                NaviErrorDialog.show(parent, "E00062: Module could not be stared", innerDescription, e2);
            }
        }
    }

    public static void toggleStars(JFrame parent, INaviModule[] modules) {
        for (INaviModule module : modules) {
            try {
                module.getConfiguration().setStared(!module.getConfiguration().isStared());
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E000063: Module star could not be toggled";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The star state of module '%s' could not be toggled.", module.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The module star was not updated."});
                NaviErrorDialog.show(parent, "E000063: Module star could not be toggled", innerDescription, e2);
            }
        }
    }

    public static void unstar(JFrame parent, INaviModule[] modules) {
        for (INaviModule module : modules) {
            try {
                module.getConfiguration().setStared(false);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
                String innerMessage = "E00081: Module could not be unstared";
                String innerDescription = CUtilityFunctions.createDescription(String.format("The module '%s' could not be unstared.", module.getConfiguration().getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The module star was not updated."});
                NaviErrorDialog.show(parent, "E00081: Module could not be unstared", innerDescription, e2);
            }
        }
    }
}

