/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.FunctionSelection.CFunctionSelectionDialog;
import com.google.security.zynamics.binnavi.Gui.ResolveFunctions.CResolveAllFunctionDialog;
import com.google.security.zynamics.binnavi.Gui.ResolveFunctions.CResolveFunctionDialog;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.Window;

public final class CFunctionHelpers {
    private CFunctionHelpers() {
    }

    public static boolean isForwardableFunction(INaviFunction function) {
        Preconditions.checkNotNull(function, "IE02334: function argument can not be null");
        return function.getType() == FunctionType.IMPORT || function.getType() == FunctionType.THUNK;
    }

    public static void removeResolvedFunction(Window parent, INaviFunction function) {
        try {
            function.removeForwardedFunction();
        }
        catch (CouldntSaveDataException e2) {
            CUtilityFunctions.logException(e2);
            String innerMessage = "E00132: Could not remove function forwarding";
            String innerDescription = CUtilityFunctions.createDescription(String.format("The forwarding of function '%s' could not be removed.", function.getName()), new String[]{"There was a problem with the database connection."}, new String[]{"The function forwarding of the selected function remains unchanged."});
            NaviErrorDialog.show(parent, "E00132: Could not remove function forwarding", innerDescription, e2);
        }
    }

    public static void resolveAllFunctions(Window parent, IDatabase database) {
        new CResolveAllFunctionDialog(parent, database);
    }

    public static void resolveAllFunctions(Window parent, IDatabase database, INaviAddressSpace addressSpace) {
        new CResolveAllFunctionDialog(parent, database, addressSpace);
    }

    public static void resolveAllFunctions(Window parent, IDatabase database, INaviModule module) {
        new CResolveAllFunctionDialog(parent, database, module);
    }

    public static void resolveAllFunctions(Window parent, IDatabase database, INaviProject project) {
        new CResolveAllFunctionDialog(parent, database, project);
    }

    public static void resolveFunction(Window parent, IDatabase database, INaviFunction function) {
        CFunctionSelectionDialog dlg = new CFunctionSelectionDialog(parent, database);
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
        INaviFunction selectedFunction = dlg.getSelectedFunction();
        if (selectedFunction != null) {
            try {
                function.setForwardedFunction(selectedFunction);
            }
            catch (CouldntSaveDataException e2) {
                CUtilityFunctions.logException(e2);
            }
        }
    }

    public static void resolveFunctions(Window parent, IDatabase database, INaviModule module) {
        CResolveFunctionDialog dlg = new CResolveFunctionDialog(parent, database, module);
        GuiHelper.centerChildToParent(parent, dlg, true);
        dlg.setVisible(true);
    }
}

