/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.CDatabase;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNameListGenerators;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNodeExpander;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.INodeSelectionUpdater;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Updaters.ITreeUpdater;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.debug.debugger.DebuggerTemplate;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import javax.swing.JFrame;
import javax.swing.JTree;

public final class CDatabaseFunctions {
    private CDatabaseFunctions() {
    }

    public static void addDebugger(final JFrame parent, final IDatabase database, final String name, final String host, final int port, final INodeSelectionUpdater updater) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                try {
                    operation.getProgressPanel().setMaximum(1);
                    operation.getProgressPanel().setText("Creating new debugger");
                    DebuggerTemplate template = database.getContent().getDebuggerTemplateManager().createDebugger(name, host, port);
                    updater.setObject(template);
                    updater.update();
                }
                catch (CouldntSaveDataException exception) {
                    CUtilityFunctions.logException(exception);
                    String message2 = "E00028: Debugger could not be created";
                    String description = CUtilityFunctions.createDescription(String.format("The debugger '%s' could not be created. Try creating the debugger again. If the problem persists, disconnect from and reconnect to the database, restart BinNavi, or contact the BinNavi support.", name), new String[]{"Database connection problems."}, new String[]{"The debugger was not created."});
                    NaviErrorDialog.show(parent, "E00028: Debugger could not be created", description, exception);
                }
                finally {
                    operation.getProgressPanel().next();
                    operation.stop();
                }
            }
        }.start();
    }

    public static void addNewDatabase(JTree projectTree) {
        CDatabase newDatabase = new CDatabase("New Database", "org.postgresql.Driver", "localhost", "new_database", "user", "password", "identity", false, false);
        CDatabaseManager.instance().addDatabase(newDatabase);
        CNodeExpander.setSelectionPath(projectTree, newDatabase);
    }

    public static void deleteDebuggers(final JFrame parent, final IDatabase database, DebuggerTemplate[] debuggers, final ITreeUpdater updater) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the following debuggers from the database?\n\n%s", CNameListGenerators.getNameList(debuggers))) == 0) {
            for (final DebuggerTemplate debugger : debuggers) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Removing debugger: ");
                        String string3 = String.valueOf(debugger.getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        operation.getProgressPanel().next();
                        try {
                            database.getContent().getDebuggerTemplateManager().removeDebugger(debugger);
                            updater.update();
                        }
                        catch (CouldntDeleteException exception) {
                            CUtilityFunctions.logException(exception);
                            String message2 = "E00030: Debugger could not be deleted";
                            String description = CUtilityFunctions.createDescription(String.format("The debugger '%s' could not be deleted. Try to delete the debugger again. If the problem persists, disconnect from and reconnect to the database, restart BinNavi, or contact the BinNavi support.", debugger.getName()), new String[]{"Database connection problems."}, new String[]{"The debugger still exists."});
                            NaviErrorDialog.show(parent, "E00030: Debugger could not be deleted", description, exception);
                        }
                        finally {
                            operation.stop();
                        }
                    }
                }.start();
            }
        }
    }

    public static void deleteProjects(final JFrame parent, final IDatabase database, INaviProject[] projects, final ITreeUpdater updater) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to delete the following projects?\n\n%s", CNameListGenerators.getNameList(projects))) == 0) {
            for (final INaviProject project : projects) {
                new Thread(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        CDefaultProgressOperation operation = new CDefaultProgressOperation("", false, true);
                        operation.getProgressPanel().setMaximum(1);
                        String string2 = String.valueOf("Deleting project: ");
                        String string3 = String.valueOf(project.getConfiguration().getName());
                        operation.getProgressPanel().setText(string3.length() != 0 ? string2.concat(string3) : new String(string2));
                        try {
                            database.getContent().delete(project);
                            operation.getProgressPanel().next();
                            updater.update();
                        }
                        catch (CouldntDeleteException exception) {
                            CUtilityFunctions.logException(exception);
                            String message2 = "E00032: Project could not be deleted";
                            String description = CUtilityFunctions.createDescription(String.format("The project '%s' could not be deleted. Try to delete the project again. If the problem persists, disconnect from and reconnect to the database, restart BinNavi, or contact the BinNavi support.", project.getConfiguration().getName()), new String[]{"Database connection problems."}, new String[]{"The project still exists."});
                            NaviErrorDialog.show(parent, "E00032: Project could not be deleted", description, exception);
                        }
                        finally {
                            operation.stop();
                        }
                    }
                }.start();
            }
        }
    }

    public static void refreshRawModules(final JFrame parent, final IDatabase database) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CDefaultProgressOperation operation = new CDefaultProgressOperation("", true, false);
                try {
                    operation.getProgressPanel().setMaximum(1);
                    operation.getProgressPanel().setText("Refreshing modules");
                    try {
                        database.getContent().refreshRawModules();
                    }
                    catch (CouldntLoadDataException exception) {
                        CUtilityFunctions.logException(exception);
                        String message2 = "E00036: Could not refresh raw modules";
                        String description = CUtilityFunctions.createDescription("The list of raw modules could not be refreshed. Try refreshing the raw modules again.", new String[]{"Database connection problems."}, new String[]{"More raw modules than those shown in the raw modules list might exist in the database."});
                        NaviErrorDialog.show(parent, "E00036: Could not refresh raw modules", description, exception);
                    }
                }
                finally {
                    operation.getProgressPanel().next();
                    operation.stop();
                }
            }
        }.start();
    }

    public static void removeDatabase(JFrame parent, IDatabase database, ITreeUpdater updater) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to remove the database configuration '%s' from BinNavi?", database.getConfiguration().getDescription())) == 0) {
            CDatabaseManager.instance().removeDatabase(database);
            updater.update();
            ConfigManager.instance().saveSettings(parent);
        }
    }
}

