/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.Database.CDatabaseLoader;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNodeExpander;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import java.awt.Window;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public final class CDatabaseConnectionFunctions {
    private CDatabaseConnectionFunctions() {
    }

    private static void openDatabaseThreaded(final Window parent, final JTree projectTree, final IDatabase database) {
        new Thread(){

            @Override
            public void run() {
                boolean loadRequired = true;
                while (database.isLoading() || database.isConnecting()) {
                    loadRequired = false;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e2) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (loadRequired) {
                    CDatabaseLoader.loadDatabase(parent, database);
                }
                if (projectTree != null && database.isConnected()) {
                    new SwingInvoker(){

                        @Override
                        protected void operation() {
                            CNodeExpander.expandNode(projectTree, database);
                        }
                    }.invokeLater();
                }
            }
        }.start();
    }

    public static void closeDatabase(Window parent, IDatabase database) {
        if (!database.close()) {
            CMessageBox.showInformation(parent, "Could not close the selected database because views or other elements from the database are still open.");
        }
    }

    public static void openDatabase(JTree projectTree, IDatabase database) {
        CDatabaseConnectionFunctions.openDatabaseThreaded(SwingUtilities.getWindowAncestor(projectTree), projectTree, database);
    }

    public static void openDatabase(Window parent, IDatabase database) {
        CDatabaseConnectionFunctions.openDatabaseThreaded(parent, null, database);
    }
}

