/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntLoadDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Database.Exceptions.LoadCancelledException;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CCallgraphCombiner;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNameListGenerators;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CNodeExpander;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CShowViewFunctions;
import com.google.security.zynamics.binnavi.Gui.Progress.CDefaultProgressOperation;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.INaviProject;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.SwingInvoker;
import javax.swing.JFrame;
import javax.swing.JTree;
import javax.swing.SwingUtilities;

public final class CAddressSpaceFunctions {
    private CAddressSpaceFunctions() {
    }

    public static void addModule(final JFrame parent, final INaviAddressSpace addressSpace, final INaviModule module) {
        if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to add the module '%s' to the address space '%s'?", module.getConfiguration().getName(), addressSpace.getConfiguration().getName())) == 0) {
            new Thread(){

                @Override
                public void run() {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("Adding modules to address space", false, true);
                    operation.getProgressPanel().setMaximum(1);
                    String string2 = String.valueOf("Adding module to address space: '");
                    String string3 = module.getConfiguration().getName();
                    operation.getProgressPanel().setText(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).append("'").toString());
                    try {
                        addressSpace.getContent().addModule(module);
                    }
                    catch (CouldntSaveDataException exception) {
                        CUtilityFunctions.logException(exception);
                        String message2 = "E00026: Module could not be added to address space";
                        String description = CUtilityFunctions.createDescription(String.format("The module '%s' could not be added to the address space '%s'. Try adding the module to the address space again. If the problem persists, disconnect from and reconnect to the database, restart com.google.security.zynamics.binnavi, or contact the BinNavi support.", module.getConfiguration().getName(), addressSpace.getConfiguration().getName()), new String[]{"Database connection problems."}, new String[]{"The address space remains unchanged."});
                        NaviErrorDialog.show(parent, "E00026: Module could not be added to address space", description, exception);
                    }
                    operation.stop();
                }
            }.start();
        }
    }

    public static void createCombinedCallgraph(final JFrame parent, final IViewContainer container, final INaviProject project, final INaviAddressSpace addressSpace) {
        new Thread(){

            @Override
            public void run() {
                String string2 = String.valueOf("Creating combined call graph: ");
                String string3 = String.valueOf(addressSpace.getConfiguration().getName());
                CDefaultProgressOperation operation = new CDefaultProgressOperation(string3.length() != 0 ? string2.concat(string3) : new String(string2), true, false);
                operation.getProgressPanel().setText("Creating combined call graph");
                INaviView view = CCallgraphCombiner.createCombinedCallgraph(project, addressSpace);
                operation.stop();
                CShowViewFunctions.showViewInLastWindow(parent, container, new INaviView[]{view});
            }
        }.start();
    }

    public static void loadAddressSpaces(final JTree projectTree, final INaviAddressSpace[] addressSpaces) {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CDefaultProgressOperation operation = new CDefaultProgressOperation("Loading address spaces", false, true);
                operation.getProgressPanel().setMaximum(addressSpaces.length);
                for (final INaviAddressSpace addressSpace : addressSpaces) {
                    String string2 = String.valueOf("Loading address spaces: '");
                    String string3 = addressSpace.getConfiguration().getName();
                    operation.getProgressPanel().setText(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).append("'").toString());
                    try {
                        addressSpace.load();
                        new SwingInvoker(){

                            @Override
                            protected void operation() {
                                CNodeExpander.expandNode(projectTree, addressSpace);
                            }
                        }.invokeLater();
                    }
                    catch (CouldntLoadDataException exception) {
                        CUtilityFunctions.logException(exception);
                        String message2 = "E00109: Address space could not be loaded";
                        String description = CUtilityFunctions.createDescription(String.format("The address space '%s' could not be loaded. Try loading the address space again. If the problem persists, disconnect from and reconnect to the database, restart com.google.security.zynamics.binnavi, or contact the BinNavi support.", addressSpace.getConfiguration().getName()), new String[]{"Database connection problems."}, new String[]{"The address space was not loaded."});
                        NaviErrorDialog.show(SwingUtilities.getWindowAncestor(projectTree), "E00109: Address space could not be loaded", description, exception);
                    }
                    catch (LoadCancelledException loadCancelledException) {
                    }
                    finally {
                        operation.getProgressPanel().next();
                    }
                }
                operation.stop();
            }
        }.start();
    }

    public static void removeModules(final JFrame parent, final INaviAddressSpace addressSpace, final INaviModule[] modules) {
        new Thread(){

            @Override
            public void run() {
                if (CMessageBox.showYesNoQuestion(parent, String.format("Do you really want to remove the following modules from the address space?\n\n%s", CNameListGenerators.getNameList(modules))) == 0) {
                    CDefaultProgressOperation operation = new CDefaultProgressOperation("Removing modules from address space", false, true);
                    operation.getProgressPanel().setMaximum(modules.length);
                    for (INaviModule module : modules) {
                        String string2 = String.valueOf("Removing modules from address space: '");
                        String string3 = module.getConfiguration().getName();
                        operation.getProgressPanel().setText(new StringBuilder(1 + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).append("'").toString());
                        try {
                            addressSpace.getContent().removeModule(module);
                        }
                        catch (CouldntDeleteException exception) {
                            CUtilityFunctions.logException(exception);
                            String message2 = "E00027: Module could not be removed from address space";
                            String description = CUtilityFunctions.createDescription(String.format("The module '%s' could not be removed from the address space '%s'. Try removing the module from the address space again. If the problem persists, disconnect from and reconnect to the database, restart com.google.security.zynamics.binnavi, or contact the BinNavi support.", module.getConfiguration().getName(), addressSpace.getConfiguration().getName()), new String[]{"Database connection problems."}, new String[]{"The address space remains unchanged."});
                            NaviErrorDialog.show(parent, "E00027: Module could not be removed from address space", description, exception);
                        }
                        catch (CouldntSaveDataException exception) {
                            CUtilityFunctions.logException(exception);
                        }
                        operation.getProgressPanel().next();
                    }
                    operation.stop();
                }
            }
        }.start();
    }
}

