/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.API.plugins.IPluginInterfaceListener;
import com.google.security.zynamics.binnavi.API.plugins.PluginInterface;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.CProjectTree;
import com.google.security.zynamics.binnavi.Gui.MainWindow.ProjectTree.Nodes.IProjectTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class CProjectMainPanel
extends JPanel {
    private static final long serialVersionUID = 2093952613078997535L;
    private final JFrame m_window;
    private final JPanel m_componentPanel = new JPanel(new BorderLayout());
    private final CProjectTree m_projectTree;
    private final InternalPluginListener m_pluginListener = new InternalPluginListener();

    public CProjectMainPanel(JFrame window, CDatabaseManager databaseManager) {
        super(new BorderLayout());
        this.m_window = Preconditions.checkNotNull(window, "IE01830: Window argument can't be null");
        Preconditions.checkNotNull(databaseManager, "IE01831: Database manager argument can't be null");
        this.m_projectTree = new CProjectTree(this.m_window, databaseManager);
        this.add((Component)this.createMainSplitPane(), "Center");
        PluginInterface.instance().addListener(this.m_pluginListener);
    }

    private JSplitPane createMainSplitPane() {
        JSplitPane mainSplitPane = new JSplitPane();
        mainSplitPane.setOneTouchExpandable(true);
        mainSplitPane.setDividerLocation(250);
        mainSplitPane.setResizeWeight(0.33);
        mainSplitPane.setOrientation(1);
        this.m_componentPanel.setBackground(Color.WHITE);
        mainSplitPane.setLeftComponent(this.createProjectTreePanel());
        mainSplitPane.setRightComponent(this.m_componentPanel);
        mainSplitPane.setBorder(new LineBorder(Color.GRAY));
        return mainSplitPane;
    }

    private JPanel createProjectTreePanel() {
        JPanel projectTreePanel = new JPanel(new BorderLayout());
        projectTreePanel.setBorder(null);
        projectTreePanel.setBackground(Color.WHITE);
        this.m_projectTree.setBorder(new EmptyBorder(2, 4, 2, 2));
        this.m_projectTree.addTreeSelectionListener(new InternalTreeSelectionListener());
        JScrollPane pane = new JScrollPane(this.m_projectTree);
        pane.setVerticalScrollBarPolicy(20);
        pane.setHorizontalScrollBarPolicy(30);
        pane.setBorder(null);
        projectTreePanel.add((Component)pane, "Center");
        return projectTreePanel;
    }

    private void nodeSelected(IProjectTreeNode node) {
        Component component = node.getComponent();
        this.m_componentPanel.removeAll();
        if (component != null) {
            this.m_componentPanel.add(component);
        }
        this.m_componentPanel.updateUI();
        this.m_window.setJMenuBar(node.getMainMenu());
        this.m_window.getJMenuBar().updateUI();
    }

    public void init() {
        this.m_projectTree.setSelectionPath(new TreePath(this.m_projectTree.getRootNode()));
    }

    private class InternalTreeSelectionListener
    implements TreeSelectionListener {
        private InternalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent event) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)CProjectMainPanel.this.m_projectTree.getLastSelectedPathComponent();
            if (node != null) {
                CProjectMainPanel.this.nodeSelected((IProjectTreeNode)((Object)node));
            }
        }
    }

    private class InternalPluginListener
    implements IPluginInterfaceListener {
        private InternalPluginListener() {
        }

        @Override
        public void loadedPlugins() {
            IProjectTreeNode node = (IProjectTreeNode)CProjectMainPanel.this.m_projectTree.getLastSelectedPathComponent();
            if (node != null) {
                CProjectMainPanel.this.m_window.setJMenuBar(node.getMainMenu());
                CProjectMainPanel.this.m_window.getJMenuBar().updateUI();
            }
        }
    }
}

