/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.MainWindow;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.CDatabaseManager;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.CIconInitializer;
import com.google.security.zynamics.binnavi.Gui.FirstStartDialog.CFirstStartDialog;
import com.google.security.zynamics.binnavi.Gui.MainWindow.CProjectMainPanel;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CDatabaseConnectionFunctions;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CWindowClosingFunctions;
import com.google.security.zynamics.binnavi.Gui.Progress.CProgressStatusBar;
import com.google.security.zynamics.binnavi.Gui.SettingsDialog.CActionProvider;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.binnavi.config.GeneralSettingsConfigItem;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class CProjectMainFrame
extends JFrame {
    private static final long serialVersionUID = 8043160660496546969L;
    private final boolean m_firstStart;

    public CProjectMainFrame(CDatabaseManager databaseManager, ConfigManager configFile, boolean firstStart) {
        Preconditions.checkNotNull(databaseManager, "IE01828: Database manager can't be null");
        Preconditions.checkNotNull(configFile, "IE01829: Config file argument can't be null");
        this.m_firstStart = firstStart;
        CProjectMainPanel mainPanel = new CProjectMainPanel(this, databaseManager);
        JPanel statusBar = new JPanel(new BorderLayout());
        statusBar.add((Component)new CProgressStatusBar(), "East");
        this.add((Component)mainPanel, "Center");
        this.add((Component)statusBar, "South");
        mainPanel.init();
        this.restoreSettings(configFile);
        this.setTitle("BinNavi");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent Event2) {
                CWindowClosingFunctions.exit(CProjectMainFrame.this);
            }
        });
        CIconInitializer.initializeWindowIcons(this);
    }

    private boolean insufficientMemory() {
        return Runtime.getRuntime().maxMemory() < 524288000L;
    }

    private void restoreSettings(ConfigManager configFile) {
        if (configFile.getGeneralSettings().isMaximizeWindow().booleanValue()) {
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            this.setSize(screenSize.width, screenSize.height);
            this.setExtendedState(6);
        } else {
            GeneralSettingsConfigItem.LastOpenWindowConfigItem window = configFile.getGeneralSettings().getLastOpenWindow();
            int top = window.getTop();
            int left = window.getLeft();
            int height = window.getHeight();
            int width = window.getWidth();
            this.setLocation(left, top);
            this.setSize(width, height);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.m_firstStart) {
            CFirstStartDialog.show(this);
            CMessageBox.showInformation(this.getRootPane(), "Please configure your IDA Pro settings and install the required IDA Pro plugins now.\n\nIf you want to reconfigure these settings later you can find them in the Settings dialog of this window.");
            String file = CActionProvider.selectIDADirectory(this.getRootPane(), ConfigManager.instance().getGeneralSettings().getIdaDirectory());
            if (file != null) {
                ConfigManager.instance().getGeneralSettings().setIdaDirectory(file);
            }
        }
        if (this.insufficientMemory()) {
            CMessageBox.showInformation(this, "You are using BinNavi with less than the recommended 512 MB of memory.\nPlease check binnavi.bat in your BinNavi directory to find out how to increase the available memory.");
        }
        for (IDatabase database : CDatabaseManager.instance()) {
            if (!database.getConfiguration().isAutoConnect()) continue;
            CDatabaseConnectionFunctions.openDatabase(this, database);
        }
    }
}

