/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.Loaders;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Interfaces.IDatabase;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.CGraphWindow;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.Loader.CGraphOpener;
import com.google.security.zynamics.binnavi.Gui.Loaders.CModuleLoader;
import com.google.security.zynamics.binnavi.Gui.MainWindow.Implementations.CFunctionHelpers;
import com.google.security.zynamics.binnavi.Gui.errordialog.NaviErrorDialog;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleContainer;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.binnavi.disassembly.views.IViewContainer;
import com.google.security.zynamics.zylib.disassembly.FunctionType;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Window;

public final class CViewOpener {
    private CViewOpener() {
    }

    private static boolean isForwardedImportedFunction(INaviFunction function) {
        return function != null && CFunctionHelpers.isForwardableFunction(function) && function.getForwardedFunctionAddress() != null;
    }

    private static boolean isPureImportedFunction(INaviFunction function) {
        return function != null && function.getType() == FunctionType.IMPORT && function.getForwardedFunctionAddress() == null;
    }

    private static void showForwardedFunction(Window parent, IViewContainer container, INaviView view, INaviFunction function, CGraphWindow window) {
        if (container instanceof CModuleContainer) {
            CMessageBox.showInformation(parent, "Please open forwarded views from inside a project.");
            return;
        }
        IDatabase database = container.getDatabase();
        int moduleId = function.getForwardedFunctionModuleId();
        INaviModule forwardedModule = database.getContent().getModule(moduleId);
        if (forwardedModule == null) {
            String message2 = "E00019: Forwarded view can not be loaded (Unknown module)";
            String description = CUtilityFunctions.createDescription("BinNavi could not open the forwarded view because the module of the forwarding target is unknown.", new String[]{"Probably the result of a bug in BinNavi"}, new String[]{"The view can not be opened. Try to update the forwarding target again. Restart BinNavi if the view can still not be opened. Contact the BinNavi support if necessary."});
            NaviErrorDialog.show(parent, "E00019: Forwarded view can not be loaded (Unknown module)", description);
        } else if (forwardedModule.isLoaded()) {
            IAddress address = function.getForwardedFunctionAddress();
            INaviFunction forwardedFunction = forwardedModule.getContent().getFunctionContainer().getFunction(address);
            if (forwardedFunction == null) {
                String message3 = "E00020: Forwarded view can not be loaded (Unknown function)";
                String description = CUtilityFunctions.createDescription("BinNavi could not open the forwarded view because the target function is unknown.", new String[]{"Probably the result of a bug in BinNavi"}, new String[]{"The view can not be opened. Try to update the forwarding target again. Restart BinNavi if the view can still not be opened. Contact the BinNavi support if necessary."});
                NaviErrorDialog.show(parent, "E00020: Forwarded view can not be loaded (Unknown function)", description);
            } else {
                INaviView forwardedView = forwardedModule.getContent().getViewContainer().getView(forwardedFunction);
                if (forwardedView == null) {
                    String message4 = "E00107: Forwarded view can not be loaded (Unknown view)";
                    String description = CUtilityFunctions.createDescription("BinNavi could not open the forwarded view because the target view is unknown.", new String[]{"Probably the result of a bug in BinNavi"}, new String[]{"The view can not be opened. Try to update the forwarding target again. Restart BinNavi if the view can still not be opened. Contact the BinNavi support if necessary."});
                    NaviErrorDialog.show(parent, "E00107: Forwarded view can not be loaded (Unknown view)", description);
                } else {
                    CGraphOpener.showGraph(container, forwardedView, window, parent);
                }
            }
        } else if (CMessageBox.showYesNoQuestion(parent, "The view can not be opened because it is forwarded to an unloaded module.\n\nDo you want to load the forwarded module now?") == 0) {
            CModuleLoader.loadModule(parent, forwardedModule);
            if (forwardedModule.isLoaded()) {
                CViewOpener.showForwardedFunction(parent, container, view, function, window);
            }
        }
    }

    public static void showView(Window parent, IViewContainer viewContainer, INaviView view, CGraphWindow window) {
        Preconditions.checkNotNull(parent, "IE00015: Parent argument can not be null");
        Preconditions.checkNotNull(viewContainer, "IE00016: View container argument can not be null");
        Preconditions.checkNotNull(view, "IE00018: View argument can not be null");
        Preconditions.checkState(viewContainer.isLoaded(), "IE00017: View container must be loaded");
        Preconditions.checkState(viewContainer.getViews().contains(view), "IE00019: View is not part of the given view container");
        INaviFunction function = viewContainer.getFunction(view);
        if (CViewOpener.isPureImportedFunction(function)) {
            CMessageBox.showInformation(parent, "Imported functions are not part of a module and can not be opened.\nNote that it is possible to open imported functions once they are forwarded to real functions in other modules.");
            return;
        }
        if (CViewOpener.isForwardedImportedFunction(function)) {
            CViewOpener.showForwardedFunction(parent, viewContainer, view, function, window);
        } else {
            CGraphOpener.showGraph(viewContainer, view, window, parent);
        }
    }

    public static void showViewAndCallBack(Window parent, IViewContainer viewContainer, INaviView view, CGraphWindow window, FutureCallback<Boolean> callBack) {
        INaviFunction function = viewContainer.getFunction(view);
        if (CViewOpener.isPureImportedFunction(function)) {
            CMessageBox.showInformation(parent, "Imported functions are not part of a module and can not be opened.\nNote that it is possible to open imported functions once they are forwarded to real functions in other modules.");
            return;
        }
        if (CViewOpener.isForwardedImportedFunction(function)) {
            CViewOpener.showForwardedFunction(parent, viewContainer, view, function, window);
        } else {
            CGraphOpener.showGraphAndPerformCallBack(viewContainer, view, window, parent, callBack);
        }
    }
}

