/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.InsertViewDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.InsertViewDialog.CViewIconNode;
import com.google.security.zynamics.binnavi.Gui.InsertViewDialog.IViewSelectionTreeNode;
import com.google.security.zynamics.binnavi.Gui.Loaders.CModuleLoader;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.binnavi.disassembly.Modules.CModuleListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.Modules.IModuleListener;
import com.google.security.zynamics.binnavi.disassembly.views.INaviView;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;

public final class ViewSelectionModuleNode
extends IconNode
implements IViewSelectionTreeNode {
    private static final ImageIcon ICON_MODULE = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module.png"));
    private static final ImageIcon ICON_MODULE_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/project_module_gray.png"));
    private final Window m_dialog;
    private final INaviModule m_module;
    private final DefaultTreeModel m_model;
    private final IModuleListener m_internalModuleListener = new InternalModuleListener();

    public ViewSelectionModuleNode(Window parent, INaviModule module, DefaultTreeModel model) {
        Preconditions.checkNotNull(module, "IE01821: Module argument can not be null");
        this.m_dialog = parent;
        this.m_module = module;
        this.m_model = model;
        this.m_module.addListener(this.m_internalModuleListener);
        this.createChildren();
    }

    private void createChildren() {
        if (this.m_module.isLoaded()) {
            for (INaviView view : this.m_module.getContent().getViewContainer().getViews()) {
                if (view.getNodeCount() == 0) continue;
                this.add(new CViewIconNode(view));
            }
        }
    }

    @Override
    public void doubleClicked() {
        if (!this.m_module.isLoaded()) {
            CModuleLoader.loadModule(this.m_dialog, this.m_module);
        }
    }

    @Override
    public Icon getIcon() {
        return this.m_module.isLoaded() ? ICON_MODULE : ICON_MODULE_GRAY;
    }

    @Override
    public String toString() {
        return this.m_module.getConfiguration().getName();
    }

    private class InternalModuleListener
    extends CModuleListenerAdapter {
        private InternalModuleListener() {
        }

        @Override
        public void addedView(INaviModule module, INaviView view) {
            ViewSelectionModuleNode.this.m_model.nodeChanged(ViewSelectionModuleNode.this);
        }

        @Override
        public void changedName(INaviModule module, String name) {
            ViewSelectionModuleNode.this.m_model.nodeChanged(ViewSelectionModuleNode.this);
        }

        @Override
        public void loadedModule(INaviModule module) {
            ViewSelectionModuleNode.this.createChildren();
            ViewSelectionModuleNode.this.m_model.nodeStructureChanged(ViewSelectionModuleNode.this);
        }
    }
}

