/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.InsertViewDialog;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CMain;
import com.google.security.zynamics.binnavi.Gui.InsertViewDialog.IViewSelectionTreeNode;
import com.google.security.zynamics.binnavi.Gui.InsertViewDialog.ViewSelectionModuleNode;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceConfigurationListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.CAddressSpaceListenerAdapter;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceConfigurationListener;
import com.google.security.zynamics.binnavi.disassembly.AddressSpaces.IAddressSpaceListener;
import com.google.security.zynamics.binnavi.disassembly.INaviAddressSpace;
import com.google.security.zynamics.binnavi.disassembly.INaviModule;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import java.awt.Window;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultTreeModel;

public final class CAddressSpaceNode
extends IconNode
implements IViewSelectionTreeNode {
    private static final long serialVersionUID = 7984412952756615230L;
    private static final ImageIcon ICON_ADDRESSSPACE = new ImageIcon(CMain.class.getResource("data/projecttreeicons/addressspace2.png"));
    private static final ImageIcon ICON_ADDRESSSPACE_GRAY = new ImageIcon(CMain.class.getResource("data/projecttreeicons/addressspace_gray.png"));
    private final INaviAddressSpace m_addressSpace;
    private final Window m_parent;
    private final DefaultTreeModel m_model;
    private final IAddressSpaceListener m_internalSpaceListener = new InternalSpaceListener();
    private final IAddressSpaceConfigurationListener m_internalSpaceConfigurationListener = new InternalAddressSpaceConfigurationListener();

    public CAddressSpaceNode(Window parent, INaviAddressSpace addressSpace, DefaultTreeModel model) {
        this.m_addressSpace = Preconditions.checkNotNull(addressSpace, "IE01820: Address space argument can not be null");
        this.m_parent = Preconditions.checkNotNull(parent, "IE02332: Parent argument can not be null");
        this.m_model = Preconditions.checkNotNull(model, "IE02333: Model argument can not be null");
        this.m_addressSpace.addListener(this.m_internalSpaceListener);
        this.m_addressSpace.getConfiguration().addListener(this.m_internalSpaceConfigurationListener);
        this.createChildren();
    }

    private void createChildren() {
        if (this.m_addressSpace.isLoaded()) {
            for (INaviModule module : this.m_addressSpace.getContent().getModules()) {
                this.add(new ViewSelectionModuleNode(this.m_parent, module, this.m_model));
            }
        }
    }

    @Override
    public void doubleClicked() {
    }

    @Override
    public Icon getIcon() {
        return this.m_addressSpace.isLoaded() ? ICON_ADDRESSSPACE : ICON_ADDRESSSPACE_GRAY;
    }

    @Override
    public String toString() {
        return this.m_addressSpace.getConfiguration().getName();
    }

    private class InternalSpaceListener
    extends CAddressSpaceListenerAdapter {
        private InternalSpaceListener() {
        }

        @Override
        public void loaded(INaviAddressSpace addressSpace) {
            CAddressSpaceNode.this.createChildren();
            CAddressSpaceNode.this.m_model.nodeStructureChanged(CAddressSpaceNode.this);
        }
    }

    private class InternalAddressSpaceConfigurationListener
    extends CAddressSpaceConfigurationListenerAdapter {
        private InternalAddressSpaceConfigurationListener() {
        }

        @Override
        public void changedName(INaviAddressSpace module, String name) {
            CAddressSpaceNode.this.m_model.nodeChanged(CAddressSpaceNode.this);
        }
    }
}

