/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.IdbSelection;

import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.CBinExportInstallationChecker;
import com.google.security.zynamics.binnavi.Gui.IdaSelectionDialog.InstallationState;
import com.google.security.zynamics.binnavi.Gui.IdbSelection.CIdbFileList;
import com.google.security.zynamics.binnavi.Gui.IdbSelection.CPreviousDirectoriesBox;
import com.google.security.zynamics.binnavi.Gui.IdbSelection.ExporterSelection;
import com.google.security.zynamics.binnavi.Importers.CIdbFileFilter;
import com.google.security.zynamics.binnavi.config.ConfigManager;
import com.google.security.zynamics.zylib.gui.CDialogEscaper;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.CPanelTwoButtons;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public final class CIdbSelectionDialog
extends JDialog {
    private final JComboBox<?> m_previousDirectoryBox;
    private final JComboBox<?> m_exportersBox;
    private final JSlider m_threadsSlider;
    private final IFilledList<File> m_selectedFiles = new FilledList<File>();
    private final JFileChooser m_chooser;
    private final CIdbFileList m_selectionList = new CIdbFileList();
    private ExporterSelection m_exporter;

    private CIdbSelectionDialog(JFrame parent, List<String> previousDirectories) {
        super(parent, "Select IDB files for importing", true);
        File file;
        new CDialogEscaper(this);
        JPanel upperPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        JLabel availableExportersLabel = new JLabel("Available Exporters:");
        availableExportersLabel.setBorder(new EmptyBorder(10, 5, 10, 5));
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        upperPanel.add((Component)availableExportersLabel, constraints);
        this.m_exportersBox = new JComboBox<Object>(new Object[]{"BinExport IDA plugin"});
        this.m_exportersBox.setBorder(new EmptyBorder(10, 5, 10, 5));
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        upperPanel.add(this.m_exportersBox, constraints);
        JLabel previousDirectoriesLabel = new JLabel("Previous directories:");
        previousDirectoriesLabel.setBorder(new EmptyBorder(10, 5, 10, 5));
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 1.0;
        constraints.fill = 0;
        upperPanel.add((Component)previousDirectoriesLabel, constraints);
        this.m_previousDirectoryBox = new CPreviousDirectoriesBox(previousDirectories);
        this.m_previousDirectoryBox.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.m_previousDirectoryBox.addItemListener(new InternalItemListener());
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        upperPanel.add(this.m_previousDirectoryBox, constraints);
        JLabel parallelImportsLabel = new JLabel("Number of parallel imports:");
        parallelImportsLabel.setBorder(new EmptyBorder(10, 5, 10, 5));
        constraints.anchor = 23;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        upperPanel.add((Component)parallelImportsLabel, constraints);
        JPanel innerPanel = new JPanel(new BorderLayout());
        this.m_threadsSlider = new JSlider(0, 1, 20, 3);
        this.m_threadsSlider.setPaintLabels(true);
        this.m_threadsSlider.setPaintTicks(true);
        this.m_threadsSlider.setPaintTrack(true);
        this.m_threadsSlider.setMajorTickSpacing(1);
        this.m_threadsSlider.setSnapToTicks(true);
        this.m_threadsSlider.setBorder(new EmptyBorder(10, 5, 10, 5));
        innerPanel.add(this.m_threadsSlider);
        constraints.gridx = 1;
        constraints.gridy = 2;
        constraints.weightx = 5.0;
        constraints.fill = 2;
        upperPanel.add((Component)innerPanel, constraints);
        JPanel leftMiddlePanel = new JPanel(new BorderLayout());
        this.m_chooser = new JFileChooser(){
            private static final long serialVersionUID = 4054469348978937674L;

            @Override
            public void approveSelection() {
                if (!CIdbSelectionDialog.this.updateSelectedExporter()) {
                    return;
                }
                CIdbSelectionDialog.this.m_selectedFiles.add(CIdbSelectionDialog.this.m_chooser.getSelectedFile());
                CIdbSelectionDialog.this.dispose();
            }

            @Override
            public void cancelSelection() {
                CIdbSelectionDialog.this.dispose();
            }
        };
        this.m_chooser.setControlButtonsAreShown(false);
        this.m_chooser.setFileFilter(new CIdbFileFilter());
        this.m_chooser.setMultiSelectionEnabled(true);
        if (!previousDirectories.isEmpty() && (file = new File(previousDirectories.get(0))).exists() && file.isDirectory()) {
            this.m_chooser.setCurrentDirectory(file);
        }
        leftMiddlePanel.add(this.m_chooser);
        leftMiddlePanel.setBorder(new TitledBorder("Select IDB Files"));
        JPanel rightPanel = new JPanel(new BorderLayout());
        JPanel centerButtonPanel = new JPanel();
        centerButtonPanel.setLayout(new BoxLayout(centerButtonPanel, 2));
        JPanel innerCenterButtonPanel = new JPanel();
        innerCenterButtonPanel.setLayout(new BoxLayout(innerCenterButtonPanel, 3));
        centerButtonPanel.add(innerCenterButtonPanel);
        JButton addButton = new JButton(new CAddFilesAction());
        JButton removeButton = new JButton(new CRemoveFilesAction());
        innerCenterButtonPanel.add(addButton);
        innerCenterButtonPanel.add(Box.createVerticalStrut(15));
        innerCenterButtonPanel.add(removeButton);
        innerCenterButtonPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        rightPanel.add((Component)centerButtonPanel, "West");
        JPanel listPanel = new JPanel(new BorderLayout());
        listPanel.add(new JScrollPane(this.m_selectionList));
        listPanel.setBorder(new TitledBorder("Selected IDB Files"));
        rightPanel.add(listPanel);
        rightPanel.setBorder(new EmptyBorder(0, 5, 0, 5));
        JPanel middlePanel = new JPanel(new BorderLayout());
        middlePanel.add((Component)leftMiddlePanel, "West");
        middlePanel.add(rightPanel);
        JPanel lowerPanel = new JPanel(new BorderLayout());
        CPanelTwoButtons buttonPanel = new CPanelTwoButtons(new InternalActionListener(), "Cancel", "Import");
        lowerPanel.add((Component)buttonPanel, "East");
        this.add((Component)upperPanel, "North");
        this.add((Component)middlePanel, "Center");
        this.add((Component)lowerPanel, "South");
        this.setSize(800, 600);
    }

    private static boolean checkExporterInstall(Container parent) {
        File directory = new File(ConfigManager.instance().getGeneralSettings().getIdaDirectory());
        if (directory == null || !directory.exists()) {
            CMessageBox.showError(parent, "The selected exporter is not installed properly. Please configure the exporter in the IDA Pro configuration dialog.");
            return false;
        }
        InstallationState cppState = CBinExportInstallationChecker.getState(directory);
        if (cppState != InstallationState.Installed) {
            CMessageBox.showError(parent, "The selected exporter is not installed properly. Please configure the exporter in the IDA Pro configuration dialog.");
            return false;
        }
        return true;
    }

    public static CIdbSelectionDialog show(JFrame parent, List<String> previousDirectories) {
        if (!CIdbSelectionDialog.checkExporterInstall(parent)) {
            return null;
        }
        CIdbSelectionDialog dialog = new CIdbSelectionDialog(parent, previousDirectories);
        if (parent != null) {
            GuiHelper.centerChildToParent(parent, dialog, true);
        }
        dialog.setVisible(true);
        return dialog;
    }

    private boolean updateSelectedExporter() {
        this.m_exporter = ExporterSelection.BinExport;
        return CIdbSelectionDialog.checkExporterInstall(this.getParent());
    }

    public int getNumberOfParallelImports() {
        return this.m_threadsSlider.getValue();
    }

    public ExporterSelection getSelectedExporter() {
        return this.m_exporter;
    }

    public List<File> getSelectedFiles() {
        return new FilledList<File>((Collection<File>)this.m_selectedFiles);
    }

    private class InternalItemListener
    implements ItemListener {
        private InternalItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent event) {
            File file = new File(event.getItem().toString());
            if (file.exists() && file.isDirectory()) {
                CIdbSelectionDialog.this.m_chooser.setCurrentDirectory(file);
            }
        }
    }

    private class InternalActionListener
    implements ActionListener {
        private InternalActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand().equals("Import")) {
                if (!CIdbSelectionDialog.this.updateSelectedExporter()) {
                    return;
                }
                if (CIdbSelectionDialog.this.m_selectionList.getFileCount() == 0) {
                    for (File file : CIdbSelectionDialog.this.m_chooser.getSelectedFiles()) {
                        CIdbSelectionDialog.this.m_selectedFiles.add(file);
                    }
                } else {
                    for (int i2 = 0; i2 < CIdbSelectionDialog.this.m_selectionList.getFileCount(); ++i2) {
                        CIdbSelectionDialog.this.m_selectedFiles.add(CIdbSelectionDialog.this.m_selectionList.getFileAt(i2));
                    }
                }
            }
            CIdbSelectionDialog.this.dispose();
        }
    }

    private class CRemoveFilesAction
    extends AbstractAction {
        private static final long serialVersionUID = -9004931928537737608L;

        public CRemoveFilesAction() {
            super("<<");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int[] indices = CIdbSelectionDialog.this.m_selectionList.getSelectedIndices();
            File[] files = new File[indices.length];
            for (int i2 = 0; i2 < indices.length; ++i2) {
                files[i2] = CIdbSelectionDialog.this.m_selectionList.getFileAt(indices[i2]);
            }
            for (File file : files) {
                CIdbSelectionDialog.this.m_selectionList.removeFile(file);
            }
        }
    }

    private class CAddFilesAction
    extends AbstractAction {
        private static final long serialVersionUID = 1057262675119145707L;

        public CAddFilesAction() {
            super(">>");
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            for (File file : CIdbSelectionDialog.this.m_chooser.getSelectedFiles()) {
                CIdbSelectionDialog.this.m_selectionList.addFile(file);
            }
        }
    }
}

