/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.IdbSelection;

import com.google.security.zynamics.zylib.types.lists.FilledList;
import com.google.security.zynamics.zylib.types.lists.IFilledList;
import java.io.File;
import javax.swing.AbstractListModel;
import javax.swing.JList;

public final class CIdbFileList
extends JList<File> {
    private final CIdbListModel m_listModel = new CIdbListModel();

    public CIdbFileList() {
        this.setModel(this.m_listModel);
    }

    public void addFile(File file) {
        this.m_listModel.add(file);
    }

    public File getFileAt(int index) {
        return this.m_listModel.getElementAt(index);
    }

    public int getFileCount() {
        return this.m_listModel.getSize();
    }

    public void removeFile(File file) {
        this.m_listModel.remove(file);
    }

    private static class CIdbListModel
    extends AbstractListModel<File> {
        private final IFilledList<File> m_files = new FilledList<File>();

        private CIdbListModel() {
        }

        public void add(File file) {
            if (this.m_files.contains(file)) {
                return;
            }
            this.m_files.add(file);
            this.fireIntervalAdded(file, this.m_files.size() - 1, this.m_files.size() - 1);
        }

        @Override
        public File getElementAt(int index) {
            return (File)this.m_files.get(index);
        }

        @Override
        public int getSize() {
            return this.m_files.size();
        }

        public void remove(File file) {
            if (this.m_files.remove(file)) {
                this.fireIntervalRemoved(file, 0, this.m_files.size());
            }
        }
    }
}

