/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberDialog;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class EditMemberAction
extends AbstractAction {
    private final TypeManager typeManager;
    private final JFrame owner;
    private final TypeMember selectedMember;

    public EditMemberAction(JFrame owner, TypeManager typeManager, TypeMember selectedMember) {
        super("Edit Member");
        this.typeManager = typeManager;
        this.selectedMember = selectedMember;
        this.owner = owner;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        MemberDialog dialog = MemberDialog.createEditMemberDialog(this.owner, this.typeManager, this.selectedMember);
        GuiHelper.centerChildToParent(this.owner, dialog, true);
        dialog.setVisible(true);
        if (!dialog.wasCanceled()) {
            try {
                switch (this.selectedMember.getParentType().getCategory()) {
                    case STRUCT: {
                        this.typeManager.updateStructureMember(this.selectedMember, dialog.getBaseType(), dialog.getMemberName(), this.selectedMember.getBitOffset().get());
                        break;
                    }
                    case UNION: {
                        this.typeManager.updateUnionMember(this.selectedMember, dialog.getBaseType(), dialog.getMemberName());
                        break;
                    }
                    case FUNCTION_PROTOTYPE: {
                        this.typeManager.updateFunctionPrototypeMember(this.selectedMember, dialog.getBaseType(), dialog.getMemberName(), this.selectedMember.getArgumentIndex().get());
                    }
                    default: {
                        throw new IllegalStateException("Error: can not edit a member of a non compound type.");
                    }
                }
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

