/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions;

import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberDialog;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import com.google.security.zynamics.zylib.gui.GuiHelper;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;

public class AppendMemberAction
extends AbstractAction {
    private final JFrame owner;
    private final TypeManager typeManager;
    private final BaseType selectedType;

    public AppendMemberAction(JFrame owner, TypeManager typeManager, BaseType selectedType) {
        super("Append member");
        this.owner = owner;
        this.typeManager = typeManager;
        this.selectedType = selectedType;
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        MemberDialog dlg = MemberDialog.createBuildNewMemberDialog(this.owner, this.typeManager);
        GuiHelper.centerChildToParent(this.owner, dlg, true);
        dlg.setVisible(true);
        if (!dlg.wasCanceled()) {
            String name = dlg.getMemberName();
            BaseType baseType = dlg.getBaseType();
            try {
                TypeMember member = this.typeManager.appendMember(this.selectedType, baseType, name);
                if (member == null) {
                    CMessageBox.showInformation(this.owner, "Unable to append member since that would create a recursive type definition.");
                }
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
            }
        }
    }
}

