/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.zylib.gui.CMessageBox;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class UserInputTypeValidation {
    private UserInputTypeValidation() {
    }

    public static boolean validateComboBox(Component parent, JComboBox baseTypes) {
        if (UserInputTypeValidation.validateComboBox(baseTypes)) {
            return true;
        }
        CMessageBox.showWarning(parent, "Please select a type from the list of base types.");
        return false;
    }

    public static boolean validateComboBox(JComboBox baseTypes) {
        return baseTypes.getSelectedItem() != null;
    }

    public static boolean validateTypeName(Component parent, TypeManager typeManager, JTextField name) {
        if (UserInputTypeValidation.validateTypeName(typeManager, name)) {
            return true;
        }
        CMessageBox.showWarning(parent, String.format("Unable to create empty or existing type.", new Object[0]));
        return false;
    }

    public static boolean validateTypeName(TypeManager typeManager, JTextField name) {
        return !name.getText().isEmpty() && !typeManager.isTypeExisting(name.getText());
    }

    public static boolean validateTypeSize(Component parent, JTextField size) {
        if (UserInputTypeValidation.validateTypeSize(size)) {
            return true;
        }
        CMessageBox.showWarning(parent, "Please enter a valid type size.");
        return false;
    }

    public static boolean validateTypeSize(JTextField size) {
        try {
            if (size.getText().isEmpty() || Integer.parseInt(size.getText()) < 0) {
                return false;
            }
        }
        catch (NumberFormatException exception) {
            return false;
        }
        return true;
    }
}

