/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.DefaultTypesFilter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.StackFrameTypesFilter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesFilter;
import com.google.security.zynamics.binnavi.Log.NaviLogger;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.TypeChangedListener;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.zylib.gui.jtree.IconNode;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class TypesTreeModel
extends DefaultTreeModel {
    private final HashMultimap<TypeMember, TypeMemberTreeNode> memberNodes = HashMultimap.create();
    private final HashMultimap<BaseType, TypeMemberTreeNode> nestedStructNodes = HashMultimap.create();
    private final InternalTypeListener listener = new InternalTypeListener();
    private final TypesFilter filter;

    private static int compareBaseTypeStrings(String lhs, String rhs) {
        return lhs.toLowerCase().compareTo(rhs.toLowerCase());
    }

    private TypesTreeModel() {
        super(null);
        this.filter = new DefaultTypesFilter();
    }

    public TypesTreeModel(TypeManager typeManager, TypesFilter filter) {
        super(new DefaultMutableTreeNode("invisible_root"));
        this.filter = filter;
        this.createNodes(typeManager);
        typeManager.addListener(this.listener);
    }

    public static TypesTreeModel createDefaultModel(TypeManager typeManager) {
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        return new TypesTreeModel(typeManager, new DefaultTypesFilter());
    }

    public static TypesTreeModel createEmptyTypeModel() {
        return new TypesTreeModel();
    }

    public static TypesTreeModel createSingleTypeModel(TypeManager typeManager, BaseType includedType) {
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        Preconditions.checkNotNull(includedType, "Error: includedType argument can not be null");
        return new TypesTreeModel(typeManager, new StackFrameTypesFilter(includedType, typeManager));
    }

    private TreeNode createNodes(TypeManager typeManager) {
        for (BaseType baseType : typeManager.getTypes()) {
            if (!this.filter.includeType(baseType)) continue;
            this.insertBaseType(baseType);
        }
        return this.root;
    }

    private void createTypeNodes(DefaultMutableTreeNode currentNode, BaseType baseType) {
        if (baseType.getCategory() == BaseTypeCategory.ARRAY) {
            return;
        }
        block5: for (TypeMember member : baseType) {
            switch (member.getBaseType().getCategory()) {
                case ARRAY: 
                case ATOMIC: 
                case POINTER: {
                    TypeMemberTreeNode memberNode = new TypeMemberTreeNode(member);
                    currentNode.add(memberNode);
                    this.memberNodes.put((Object)member, (Object)memberNode);
                    continue block5;
                }
                case FUNCTION_PROTOTYPE: {
                    continue block5;
                }
                case STRUCT: 
                case UNION: {
                    TypeMemberTreeNode nestedNode = new TypeMemberTreeNode(member);
                    this.memberNodes.put((Object)member, (Object)nestedNode);
                    this.nestedStructNodes.put((Object)member.getBaseType(), (Object)nestedNode);
                    currentNode.add(nestedNode);
                    this.createTypeNodes(nestedNode, member.getBaseType());
                    continue block5;
                }
            }
            NaviLogger.warning("Unknown type category: %d", new Object[]{member.getBaseType().getCategory()});
        }
    }

    private ChildNodeDescriptor insertBaseType(BaseType baseType) {
        return this.insertType((DefaultMutableTreeNode)this.root, baseType, TypesTreeModel.findInsertIndex(baseType, (DefaultMutableTreeNode)this.root));
    }

    private void removeNodes(List<DefaultMutableTreeNode> nodes) {
        for (DefaultMutableTreeNode node : nodes) {
            if (node instanceof TypeMemberTreeNode) {
                TypeMember member = ((TypeMemberTreeNode)node).getTypeMember();
                this.nestedStructNodes.get((Object)member.getBaseType()).removeAll(this.memberNodes.get((Object)member));
                this.memberNodes.remove(member, node);
            }
            node.removeFromParent();
        }
    }

    private ChildNodeDescriptor deleteBaseType(BaseType baseType) {
        ChildNodeDescriptor descriptor = this.getBaseTypeTreeNode(baseType);
        this.removeNodes(Lists.newArrayList(descriptor.getNode()));
        return descriptor;
    }

    private static int findTreeNodeIndex(BaseType baseType, DefaultMutableTreeNode root) {
        int lower = 0;
        if (root.getChildCount() == 0) {
            return 0;
        }
        int upper = root.getChildCount() - 1;
        String baseTypeString = BaseTypeTreeNode.renderBaseType(baseType);
        while (upper >= lower) {
            int middle = upper + lower >>> 1;
            int comparison = TypesTreeModel.compareBaseTypeStrings(baseTypeString, root.getChildAt(middle).toString());
            if (comparison < 0) {
                upper = middle - 1;
                continue;
            }
            if (comparison > 0) {
                lower = middle + 1;
                continue;
            }
            return middle;
        }
        return -lower;
    }

    private static int findInsertIndex(BaseType baseType, DefaultMutableTreeNode root) {
        int index = TypesTreeModel.findTreeNodeIndex(baseType, root);
        return index < 0 ? -index : index;
    }

    private ChildNodeDescriptor getBaseTypeTreeNode(BaseType baseType) {
        int index = TypesTreeModel.findTreeNodeIndex(baseType, (DefaultMutableTreeNode)this.root);
        if (index < 0 || index >= this.root.getChildCount()) {
            return new ChildNodeDescriptor();
        }
        BaseTypeTreeNode node = (BaseTypeTreeNode)((DefaultMutableTreeNode)this.root).getChildAt(index);
        return new ChildNodeDescriptor(node, index);
    }

    private ChildNodeDescriptor insertType(DefaultMutableTreeNode parentNode, BaseType baseType, int index) {
        BaseTypeTreeNode newNode = new BaseTypeTreeNode(baseType);
        parentNode.insert(newNode, index);
        this.createTypeNodes(newNode, baseType);
        return new ChildNodeDescriptor(newNode, index);
    }

    private class InternalTypeListener
    implements TypeChangedListener {
        private InternalTypeListener() {
        }

        private void addMemberNodes(TypeMember member) {
            ChildNodeDescriptor descriptor;
            int index = this.determineInsertIndex(member);
            BaseType parentType = member.getParentType();
            HashSet<IconNode> parentsToUpdate = new HashSet<IconNode>();
            if (TypesTreeModel.this.nestedStructNodes.containsKey(parentType)) {
                for (TypeMemberTreeNode node : TypesTreeModel.this.nestedStructNodes.get(parentType)) {
                    this.insertMemberAt(member, node, index);
                    parentsToUpdate.add(node);
                }
            }
            if ((descriptor = TypesTreeModel.this.getBaseTypeTreeNode(parentType)).getNode() != null) {
                this.insertMemberAt(member, descriptor.getNode(), index);
                parentsToUpdate.add(descriptor.getNode());
            }
            for (TreeNode treeNode : parentsToUpdate) {
                TypesTreeModel.this.nodeStructureChanged(treeNode);
            }
        }

        private List<DefaultMutableTreeNode> collectSubtreeNodes(DefaultMutableTreeNode node) {
            ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>();
            Enumeration<TreeNode> e2 = node.breadthFirstEnumeration();
            while (e2.hasMoreElements()) {
                nodes.add((DefaultMutableTreeNode)e2.nextElement());
            }
            return nodes;
        }

        private void deleteMemberNodes(TypeMember member) {
            TypesTreeModel.this.nestedStructNodes.get(member.getBaseType()).removeAll(TypesTreeModel.this.memberNodes.get(member));
            HashSet<MutableTreeNode> parentsToUpdate = new HashSet<MutableTreeNode>();
            for (TypeMemberTreeNode typeMemberTreeNode : TypesTreeModel.this.memberNodes.get(member)) {
                MutableTreeNode parent = (MutableTreeNode)typeMemberTreeNode.getParent();
                parentsToUpdate.add(parent);
                parent.remove(typeMemberTreeNode);
            }
            for (TreeNode treeNode : parentsToUpdate) {
                TypesTreeModel.this.nodeStructureChanged(treeNode);
            }
            TypesTreeModel.this.memberNodes.removeAll(member);
        }

        private int determineInsertIndex(TypeMember member) {
            if (!member.getBitOffset().isPresent()) {
                return 0;
            }
            int index = 0;
            for (TypeMember currentMember : member.getParentType()) {
                if (currentMember.getBitOffset().get() >= member.getBitOffset().get()) continue;
                ++index;
            }
            return index;
        }

        private void insertMemberAt(TypeMember member, DefaultMutableTreeNode parentNode, int index) {
            TypeMemberTreeNode memberNode = new TypeMemberTreeNode(member);
            parentNode.insert(memberNode, index);
            TypesTreeModel.this.createTypeNodes(memberNode, member.getBaseType());
            TypesTreeModel.this.nestedStructNodes.put(member.getBaseType(), memberNode);
            TypesTreeModel.this.memberNodes.put(member, memberNode);
        }

        @Override
        public void memberAdded(TypeMember member) {
            if (!TypesTreeModel.this.filter.includeUpdatedType(member.getParentType())) {
                return;
            }
            this.addMemberNodes(member);
        }

        @Override
        public void memberDeleted(TypeMember member) {
            if (!TypesTreeModel.this.filter.includeUpdatedType(member.getParentType())) {
                return;
            }
            this.deleteMemberNodes(member);
        }

        @Override
        public void membersMoved(final Set<BaseType> affectedTypes) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (BaseType baseType : affectedTypes) {
                        if (!TypesTreeModel.this.filter.includeType(baseType)) continue;
                        List oldNodes = InternalTypeListener.this.collectSubtreeNodes(TypesTreeModel.this.getBaseTypeTreeNode(baseType).getNode());
                        TypesTreeModel.this.removeNodes(oldNodes);
                        TypesTreeModel.this.nodeStructureChanged(TypesTreeModel.this.insertBaseType(baseType).getNode());
                    }
                }
            });
        }

        @Override
        public void memberUpdated(TypeMember member) {
            BaseType parentType = member.getParentType();
            if (!TypesTreeModel.this.filter.includeUpdatedType(parentType)) {
                return;
            }
            this.deleteMemberNodes(member);
            this.addMemberNodes(member);
        }

        @Override
        public void typeAdded(BaseType baseType) {
            if (TypesTreeModel.this.filter.includeType(baseType)) {
                ChildNodeDescriptor insertResult = TypesTreeModel.this.insertBaseType(baseType);
                TypesTreeModel.this.nodesWereInserted(TypesTreeModel.this.root, new int[]{insertResult.getIndex()});
            }
        }

        @Override
        public void typeDeleted(BaseType deletedType) {
            if (TypesTreeModel.this.filter.includeType(deletedType)) {
                ChildNodeDescriptor descriptor = TypesTreeModel.this.deleteBaseType(deletedType);
                TypesTreeModel.this.nodesWereRemoved(TypesTreeModel.this.root, new int[]{descriptor.getIndex()}, new BaseTypeTreeNode[]{descriptor.getNode()});
            }
        }

        @Override
        public void typesUpdated(Set<BaseType> baseTypes) {
            for (BaseType baseType : baseTypes) {
                if (!TypesTreeModel.this.filter.includeType(baseType)) continue;
                TypesTreeModel.this.deleteBaseType(baseType);
                ChildNodeDescriptor descriptor = TypesTreeModel.this.insertBaseType(baseType);
                TypesTreeModel.this.nodeStructureChanged(descriptor.node);
            }
        }
    }

    private class ChildNodeDescriptor {
        private final int index;
        private final BaseTypeTreeNode node;

        public ChildNodeDescriptor() {
            this.index = -1;
            this.node = null;
        }

        public ChildNodeDescriptor(BaseTypeTreeNode node, int index) {
            this.node = node;
            this.index = index;
        }

        public BaseTypeTreeNode getNode() {
            return this.node;
        }

        public int getIndex() {
            return this.index;
        }
    }
}

