/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.CUtilityFunctions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.LocalTypesFilter;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTree;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTreeModel;
import com.google.security.zynamics.binnavi.disassembly.INaviOperandTreeNode;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeHelpers;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import com.google.security.zynamics.binnavi.disassembly.types.TypeSubstitution;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class TypeSubstitutionDialog
extends JDialog {
    private TypesTree types;
    private final TypeManager typeManager;
    private final INaviOperandTreeNode selectedNode;
    private final int addendValue;
    private final JTextArea preview = new JTextArea();

    public TypeSubstitutionDialog(JFrame owner, INaviOperandTreeNode selectedNode, TypeManager typeManager, BaseType stackFrame) {
        super(owner, "Select operand type", true);
        this.typeManager = Preconditions.checkNotNull(typeManager, "IE02859: Type manager can not be null.");
        this.selectedNode = Preconditions.checkNotNull(selectedNode, "IE02860: Operand tree node can not be null.");
        this.addendValue = selectedNode.hasAddendSibling() ? (int)(selectedNode.determineAddendValue() * 8L) : 0;
        this.createControls(stackFrame);
        this.populateControls(selectedNode.getTypeSubstitution());
    }

    private void createControls(BaseType stackFrame) {
        this.setBounds(100, 100, 691, 470);
        JPanel panel = new JPanel();
        this.getContentPane().add((Component)panel, "South");
        panel.setLayout(new FlowLayout(2));
        JButton buttonOk = new JButton("OK");
        buttonOk.addActionListener(new OkActionListener());
        panel.add(buttonOk);
        JButton buttonCancel = new JButton("Cancel");
        buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                TypeSubstitutionDialog.this.dispose();
            }
        });
        buttonCancel.setActionCommand("Cancel");
        panel.add(buttonCancel);
        JPanel panel1 = new JPanel();
        this.getContentPane().add((Component)panel1, "North");
        GridBagLayout gblPanel1 = new GridBagLayout();
        gblPanel1.columnWidths = new int[]{0, 143, 114, 0};
        gblPanel1.rowHeights = new int[]{23, 0};
        gblPanel1.columnWeights = new double[]{0.0, 0.0, 1.0, Double.MIN_VALUE};
        gblPanel1.rowWeights = new double[]{0.0, Double.MIN_VALUE};
        panel1.setLayout(gblPanel1);
        JCheckBox onlyFitting = new JCheckBox("Only show structs that fit immediate offset");
        onlyFitting.setEnabled(false);
        GridBagConstraints gbcOnlyFitting = new GridBagConstraints();
        gbcOnlyFitting.anchor = 17;
        gbcOnlyFitting.insets = new Insets(0, 0, 0, 5);
        gbcOnlyFitting.gridx = 0;
        gbcOnlyFitting.gridy = 0;
        panel1.add((Component)onlyFitting, gbcOnlyFitting);
        this.types = new TypesTree();
        this.types.setModel(new TypesTreeModel(this.typeManager, new LocalTypesFilter(stackFrame)));
        this.types.getSelectionModel().setSelectionMode(1);
        this.types.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TypesTree.TypeSelectionPath path = TypeSubstitutionDialog.this.types.determineTypePath();
                if (TypeSubstitutionDialog.this.validateUserInput(path)) {
                    TypeSubstitutionDialog.this.updatePreview(path);
                }
            }
        });
        JPanel centerPanel = new JPanel();
        centerPanel.setLayout(new BoxLayout(centerPanel, 3));
        centerPanel.add(new JScrollPane(this.types));
        centerPanel.add(this.preview);
        this.getContentPane().add((Component)centerPanel, "Center");
    }

    private void createOrUpdateSubstitution(TypesTree.TypeSelectionPath path) throws CouldntSaveDataException {
        int offset = path.determineTotalMemberOffset();
        BaseType baseType = path.getRootType();
        int position = this.selectedNode.getOperandPosition();
        IAddress address = this.selectedNode.getInstructionAddress();
        TypeSubstitution substitution = this.selectedNode.getTypeSubstitution();
        List<TypeMember> memberPath = path.getMembers();
        if (substitution == null) {
            this.typeManager.createTypeSubstitution(this.selectedNode, baseType, memberPath, position, offset, address);
        } else {
            this.typeManager.updateTypeSubstitution(this.selectedNode, substitution, baseType, path.getMembers(), offset);
        }
    }

    private void populateControls(TypeSubstitution typeSubstitution) {
    }

    private boolean validateUserInput(TypesTree.TypeSelectionPath path) {
        if (!path.hasSelection()) {
            this.preview.setText("Error: No type selected.");
            return false;
        }
        if (path.containsUnion() && path.containsBaseTypeOnly()) {
            this.preview.setText("Selection is ambigious due to contained union. Please select a member explicitly.");
            return false;
        }
        int effectiveOffset = path.determineTotalMemberOffset() + this.addendValue;
        if (!BaseTypeHelpers.isValidOffset(path.getRootType(), effectiveOffset)) {
            int displayedOffset = effectiveOffset < 0 ? (effectiveOffset - 7) / 8 : (effectiveOffset + 7) / 8;
            this.preview.setText(String.format("Cannot create substitution: offset %d points outside of %s.", displayedOffset, path.getRootType().getName()));
            return false;
        }
        this.preview.setText("");
        return true;
    }

    private void updatePreview(TypesTree.TypeSelectionPath path) {
    }

    private class OkActionListener
    implements ActionListener {
        private OkActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e2) {
            try {
                TypesTree.TypeSelectionPath path = TypeSubstitutionDialog.this.types.determineTypePath();
                if (TypeSubstitutionDialog.this.validateUserInput(path)) {
                    TypeSubstitutionDialog.this.createOrUpdateSubstitution(path);
                    TypeSubstitutionDialog.this.dispose();
                }
            }
            catch (CouldntSaveDataException exception) {
                CUtilityFunctions.logException(exception);
                TypeSubstitutionDialog.this.dispose();
            }
        }
    }
}

