/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTree;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;

public class TypeEditorSearchPanel
extends JPanel {
    private final JTextField searchField;
    private final TypesTree typesTree;
    private int currentMatchIndex;
    private ImmutableList<Integer> currentMatches = ImmutableList.of();

    private static ImmutableList<Integer> determineMatches(String filterString, DefaultMutableTreeNode rootNode) {
        if (filterString.isEmpty()) {
            return ImmutableList.of();
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        String lowercaseFilter = filterString.toLowerCase();
        for (int i2 = 0; i2 < rootNode.getChildCount(); ++i2) {
            if (!rootNode.getChildAt(i2).toString().toLowerCase().contains(lowercaseFilter)) continue;
            builder.add((Object)i2);
        }
        return builder.build();
    }

    private void updateTypesTree(String filterString) {
        this.currentMatches = TypeEditorSearchPanel.determineMatches(filterString, (DefaultMutableTreeNode)this.typesTree.getModel().getRoot());
        TypeEditorSearchPanel.selectMatches(this.currentMatches, this.typesTree);
        int n2 = this.currentMatchIndex = this.currentMatches.isEmpty() ? -1 : 0;
        if (this.currentMatchIndex != -1) {
            TypeEditorSearchPanel.scrollToMatch(this.currentMatchIndex, this.currentMatches, this.typesTree);
        }
    }

    private static void selectMatches(ImmutableList<Integer> matchedRows, TypesTree tree) {
        if (matchedRows.isEmpty()) {
            tree.clearSelection();
        } else {
            int[] selectRows = new int[matchedRows.size()];
            for (int i2 = 0; i2 < matchedRows.size(); ++i2) {
                selectRows[i2] = (Integer)matchedRows.get(i2);
            }
            tree.setSelectionRows(selectRows);
        }
    }

    private static void scrollToMatch(int matchIndex, ImmutableList<Integer> matches, TypesTree tree) {
        tree.scrollRowToVisible((Integer)matches.get(matchIndex));
    }

    public TypeEditorSearchPanel(final TypesTree typesTree) {
        this.setLayout(new BoxLayout(this, 0));
        this.searchField = new JTextField();
        this.add(this.searchField);
        this.searchField.setColumns(10);
        JButton previousResult = new JButton("<");
        this.add(previousResult);
        previousResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!TypeEditorSearchPanel.this.currentMatches.isEmpty()) {
                    TypeEditorSearchPanel.this.currentMatchIndex = (TypeEditorSearchPanel.this.currentMatchIndex - 1 % TypeEditorSearchPanel.this.currentMatches.size() + TypeEditorSearchPanel.this.currentMatches.size()) % TypeEditorSearchPanel.this.currentMatches.size();
                    TypeEditorSearchPanel.selectMatches(TypeEditorSearchPanel.this.currentMatches, typesTree);
                    TypeEditorSearchPanel.scrollToMatch(TypeEditorSearchPanel.this.currentMatchIndex, TypeEditorSearchPanel.this.currentMatches, typesTree);
                }
            }
        });
        JButton nextResult = new JButton(">");
        this.add(nextResult);
        nextResult.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                if (!TypeEditorSearchPanel.this.currentMatches.isEmpty()) {
                    TypeEditorSearchPanel.this.currentMatchIndex = (TypeEditorSearchPanel.this.currentMatchIndex + 1) % TypeEditorSearchPanel.this.currentMatches.size();
                    TypeEditorSearchPanel.selectMatches(TypeEditorSearchPanel.this.currentMatches, typesTree);
                    TypeEditorSearchPanel.scrollToMatch(TypeEditorSearchPanel.this.currentMatchIndex, TypeEditorSearchPanel.this.currentMatches, typesTree);
                }
            }
        });
        this.searchField.getDocument().addDocumentListener(new TypeSearchDocumentListener());
        this.typesTree = typesTree;
    }

    private class TypeSearchDocumentListener
    implements DocumentListener {
        private TypeSearchDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent event) {
            this.updateFilter(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            this.updateFilter(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            this.updateFilter(event);
        }

        private void updateFilter(DocumentEvent event) {
            try {
                TypeEditorSearchPanel.this.updateTypesTree(event.getDocument().getText(0, event.getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }
}

