/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.DeleteMemberAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.DeleteTypeAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditor;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditorMouseHandler;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditorSearchPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypesTree;
import com.google.security.zynamics.binnavi.disassembly.INaviFunction;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.tree.TreePath;

public class TypeEditorPanel
extends JPanel
implements TypeEditor {
    private final JPanel contentPanel = new JPanel();
    private final JFrame owner;
    private final TypesTree typesTree;

    private TypeEditorPanel(JFrame owner, TypesTree treeControl, TypeManager typeManager, String caption) {
        this.owner = owner;
        this.typesTree = treeControl;
        this.createControls(typeManager, caption);
    }

    public static TypeEditorPanel CreateDefaultTypeEditor(JFrame owner, TypeManager typeManager) {
        return new TypeEditorPanel(owner, TypesTree.createDefaultDndTypesTree(typeManager), typeManager, "Type editor");
    }

    public static TypeEditorPanel CreateStackFrameEditor(JFrame owner, TypeManager typeManager, INaviFunction function) {
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        return new TypeEditorPanel(owner, TypesTree.createStackFrameDndTypesTree(function, typeManager), typeManager, "Stack frame");
    }

    public static TypeEditorPanel CreatePrototypeEditor(JFrame parent, TypeManager typeManager, INaviFunction function) {
        Preconditions.checkNotNull(typeManager, "Error: typeManager argument can not be null");
        Preconditions.checkNotNull(function, "Error: function argument can not be null");
        return new TypeEditorPanel(parent, TypesTree.createPrototypeDndTypesTree(function, typeManager), typeManager, "Prototype");
    }

    private void createControls(TypeManager typeManager, String caption) {
        this.setBounds(100, 100, 588, 529);
        this.setLayout(new BorderLayout());
        this.setBorder(new TitledBorder(new LineBorder(Color.LIGHT_GRAY, 1, true), caption));
        this.contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)new TypeEditorSearchPanel(this.typesTree), "North");
        this.add((Component)this.contentPanel, "Center");
        this.contentPanel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPane = new JScrollPane();
        this.contentPanel.add((Component)scrollPane, "Center");
        this.typesTree.addMouseListener(new TypeEditorMouseHandler(this.owner, this.typesTree, typeManager, this));
        this.typesTree.getInputMap().put(KeyStroke.getKeyStroke(127, 0, true), "delete_types_or_members");
        this.typesTree.getActionMap().put("delete_types_or_members", new DeleteTypeOrMemberAction(this.owner, typeManager, this));
        scrollPane.setViewportView(this.typesTree);
    }

    @Override
    public TypeMember getSelectedMember() {
        TreePath path = this.typesTree.getSelectionPath();
        if (path != null && path.getLastPathComponent() instanceof TypeMemberTreeNode) {
            return ((TypeMemberTreeNode)path.getLastPathComponent()).getTypeMember();
        }
        return null;
    }

    @Override
    public ImmutableList<TypeMember> getSelectedMembers() {
        ImmutableList.Builder builder = ImmutableList.builder();
        TreePath[] paths = this.typesTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : this.typesTree.getSelectionPaths()) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof TypeMemberTreeNode)) continue;
                builder.add(((TypeMemberTreeNode)node).getTypeMember());
            }
        }
        return builder.build();
    }

    @Override
    public BaseType getSelectedType() {
        TreePath path = this.typesTree.getSelectionPath();
        if (path != null && path.getLastPathComponent() instanceof BaseTypeTreeNode) {
            return ((BaseTypeTreeNode)path.getLastPathComponent()).getBaseType();
        }
        return null;
    }

    @Override
    public ImmutableList<BaseType> getSelectedTypes() {
        ImmutableList.Builder builder = ImmutableList.builder();
        TreePath[] paths = this.typesTree.getSelectionPaths();
        if (paths != null) {
            for (TreePath path : this.typesTree.getSelectionPaths()) {
                Object node = path.getLastPathComponent();
                if (!(node instanceof BaseTypeTreeNode)) continue;
                builder.add(((BaseTypeTreeNode)node).getBaseType());
            }
        }
        return builder.build();
    }

    private class DeleteTypeOrMemberAction
    extends AbstractAction {
        private final DeleteTypeAction typeAction;
        private final DeleteMemberAction memberAction;

        public DeleteTypeOrMemberAction(JFrame owner, TypeManager typeManager, TypeEditor typeEditor) {
            this.typeAction = new DeleteTypeAction(owner, typeManager, typeEditor);
            this.memberAction = new DeleteMemberAction(owner, typeManager, typeEditor);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            this.memberAction.actionPerformed(event);
            this.typeAction.actionPerformed(event);
        }
    }
}

