/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.BaseTypeTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.DeleteMemberAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.DeleteTypeAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeEditor;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeMemberTreeNode;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.AddTypeAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.AppendMemberAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.EditMemberAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.EditTypeAction;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.actions.InsertMemberAction;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TypeEditorMouseHandler
extends MouseAdapter {
    private final JTree tree;
    private final TypeEditor typeEditor;
    private final TypeManager typeManager;
    private final JFrame owner;

    public TypeEditorMouseHandler(JFrame owner, JTree tree, TypeManager typeManager, TypeEditor typeEditor) {
        this.owner = owner;
        this.tree = tree;
        this.typeManager = typeManager;
        this.typeEditor = typeEditor;
    }

    private JPopupMenu createNodeClickedMenu(TreeNode clickedNode) {
        JPopupMenu popupMenu = new JPopupMenu();
        if (clickedNode instanceof TypeMemberTreeNode) {
            TypeMember selectedMember = ((TypeMemberTreeNode)clickedNode).getTypeMember();
            EditMemberAction editMemberAction = new EditMemberAction(this.owner, this.typeManager, selectedMember);
            InsertMemberAction insertAction = new InsertMemberAction(this.owner, this.typeManager, selectedMember);
            if (this.tree.getSelectionCount() > 1) {
                editMemberAction.setEnabled(false);
                insertAction.setEnabled(false);
            }
            if (selectedMember.getParentType() != null && selectedMember.getParentType().getCategory() == BaseTypeCategory.STRUCT) {
                popupMenu.add(new AppendMemberAction(this.owner, this.typeManager, selectedMember.getParentType()));
                popupMenu.add(insertAction);
            }
            popupMenu.add(editMemberAction);
            popupMenu.add(new DeleteMemberAction(this.owner, this.typeManager, this.typeEditor));
        } else if (clickedNode instanceof BaseTypeTreeNode) {
            BaseType selectedType = ((BaseTypeTreeNode)clickedNode).getBaseType();
            EditTypeAction editAction = new EditTypeAction(this.owner, this.typeManager, selectedType);
            AppendMemberAction appendAction = new AppendMemberAction(this.owner, this.typeManager, selectedType);
            if (this.tree.getSelectionCount() > 1) {
                editAction.setEnabled(false);
                appendAction.setEnabled(false);
            } else if (selectedType.getCategory() != BaseTypeCategory.STRUCT) {
                appendAction.setEnabled(false);
            }
            popupMenu.add(editAction);
            popupMenu.add(appendAction);
            popupMenu.add(new DeleteTypeAction(this.owner, this.typeManager, this.typeEditor));
        }
        return popupMenu;
    }

    private void showMenu(MouseEvent e2) {
        JPopupMenu popupMenu;
        TreePath path = this.tree.getPathForLocation(e2.getX(), e2.getY());
        if (path != null) {
            popupMenu = this.createNodeClickedMenu((TreeNode)path.getLastPathComponent());
        } else {
            popupMenu = new JPopupMenu();
            popupMenu.add(new AddTypeAction(this.owner, this.typeManager));
        }
        popupMenu.show(e2.getComponent(), e2.getX(), e2.getY());
    }

    @Override
    public void mousePressed(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.showMenu(e2);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e2) {
        if (e2.isPopupTrigger()) {
            this.showMenu(e2);
        }
    }
}

