/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntDeleteException;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import java.awt.Component;
import javax.swing.JPanel;

public abstract class TypeDialogPanel
extends JPanel {
    protected final Component parent;
    protected final TypeManager typeManager;
    protected final BaseType existingType;

    public TypeDialogPanel(Component parent, TypeManager typeManager, BaseType existingType) {
        this.parent = Preconditions.checkNotNull(parent, "Error: parent can not be null.");
        this.typeManager = Preconditions.checkNotNull(typeManager, "Error: type manager can not be null.");
        this.existingType = existingType;
    }

    public boolean createOrUpdateType() throws CouldntSaveDataException, CouldntDeleteException {
        if (!this.validateModel()) {
            return false;
        }
        if (this.existingType == null) {
            this.createNewType();
        } else {
            this.updateExistingType();
        }
        return true;
    }

    protected abstract boolean validateModel();

    protected abstract void updateExistingType() throws CouldntSaveDataException, CouldntDeleteException;

    protected abstract void createNewType() throws CouldntSaveDataException;
}

