/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.common.base.Predicates;
import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeComboBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeDialogPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeListModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.UserInputTypeValidation;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class PointerTypePanel
extends TypeDialogPanel {
    private JSpinner pointerLevel;
    private TypeComboBox baseTypes;
    private JTextArea preview;

    private PointerTypePanel() {
        this(null, null);
    }

    public PointerTypePanel(Component parent, TypeManager typeManager) {
        this(parent, typeManager, null);
    }

    public PointerTypePanel(Component parent, TypeManager typeManager, BaseType existingType) {
        super(parent, typeManager, existingType);
        this.createControls();
        this.populateControls();
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)contentPanel, "Center");
        GridBagLayout gbl_m_contentPanel = new GridBagLayout();
        gbl_m_contentPanel.columnWidths = new int[]{0, 0, 0};
        gbl_m_contentPanel.rowHeights = new int[]{0, 0, 0, 0, 0};
        gbl_m_contentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_m_contentPanel.rowWeights = new double[]{0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        contentPanel.setLayout(gbl_m_contentPanel);
        JLabel lblBaseType = new JLabel("Base type:");
        GridBagConstraints gbc_lblBaseType = new GridBagConstraints();
        gbc_lblBaseType.anchor = 17;
        gbc_lblBaseType.insets = new Insets(0, 0, 5, 5);
        gbc_lblBaseType.gridx = 0;
        gbc_lblBaseType.gridy = 0;
        contentPanel.add((Component)lblBaseType, gbc_lblBaseType);
        this.baseTypes = new TypeComboBox(new TypeListModel(this.typeManager.getTypes(), Predicates.and(new TypeListModel.ArrayTypesFilter(), new TypeListModel.PrototypesFilter())));
        this.baseTypes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                PointerTypePanel.this.updatePreview();
            }
        });
        GridBagConstraints gbc_baseTypes = new GridBagConstraints();
        gbc_baseTypes.insets = new Insets(0, 0, 5, 0);
        gbc_baseTypes.fill = 2;
        gbc_baseTypes.gridx = 1;
        gbc_baseTypes.gridy = 0;
        contentPanel.add((Component)this.baseTypes, gbc_baseTypes);
        JLabel lblNewLabel_1 = new JLabel("Pointer level:");
        GridBagConstraints gbc_lblNewLabel_1 = new GridBagConstraints();
        gbc_lblNewLabel_1.anchor = 13;
        gbc_lblNewLabel_1.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel_1.gridx = 0;
        gbc_lblNewLabel_1.gridy = 1;
        contentPanel.add((Component)lblNewLabel_1, gbc_lblNewLabel_1);
        this.pointerLevel = new JSpinner(new SpinnerNumberModel(1, 1, 10, 1));
        this.pointerLevel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e2) {
                PointerTypePanel.this.updatePreview();
            }
        });
        GridBagConstraints gbc_m_pointerLevel = new GridBagConstraints();
        gbc_m_pointerLevel.anchor = 17;
        gbc_m_pointerLevel.insets = new Insets(0, 0, 5, 0);
        gbc_m_pointerLevel.gridx = 1;
        gbc_m_pointerLevel.gridy = 1;
        contentPanel.add((Component)this.pointerLevel, gbc_m_pointerLevel);
        JLabel lblPreview = new JLabel("Preview:");
        GridBagConstraints gbc_lblPreview = new GridBagConstraints();
        gbc_lblPreview.insets = new Insets(0, 0, 5, 5);
        gbc_lblPreview.gridx = 0;
        gbc_lblPreview.gridy = 2;
        contentPanel.add((Component)lblPreview, gbc_lblPreview);
        this.preview = new JTextArea();
        this.preview.setEditable(false);
        GridBagConstraints gbc_preview = new GridBagConstraints();
        gbc_preview.insets = new Insets(0, 0, 5, 0);
        gbc_preview.fill = 1;
        gbc_preview.gridx = 1;
        gbc_preview.gridy = 2;
        contentPanel.add((Component)this.preview, gbc_preview);
    }

    private int getPointerLevel() {
        return (Integer)this.pointerLevel.getValue();
    }

    private BaseType getSelectedType() {
        return (BaseType)this.baseTypes.getModel().getSelectedItem();
    }

    private void populateControls() {
        if (this.existingType == null) {
            return;
        }
        this.pointerLevel.setValue(this.existingType.getPointerLevel());
        this.baseTypes.getModel().selectByBaseType(BaseType.getValueType(this.existingType));
        this.updatePreview();
    }

    private void updatePreview() {
        if (UserInputTypeValidation.validateComboBox(this.baseTypes)) {
            this.preview.setText(String.format("%s my_new_type;", BaseType.getPointerTypeName(this.getSelectedType(), this.getPointerLevel())));
        }
    }

    private void createOrUpdatePointer() throws CouldntSaveDataException {
        int pointerLevel = this.getPointerLevel();
        BaseType childBaseType = this.getSelectedType();
        int existingLevel = childBaseType.getPointerLevel();
        for (int i2 = existingLevel + 1; i2 <= pointerLevel; ++i2) {
            BaseType parentType;
            childBaseType = parentType = this.typeManager.createPointerType(childBaseType);
        }
    }

    @Override
    protected boolean validateModel() {
        return UserInputTypeValidation.validateComboBox(this.parent, this.baseTypes);
    }

    @Override
    protected void updateExistingType() throws CouldntSaveDataException {
        this.createOrUpdatePointer();
    }

    @Override
    protected void createNewType() throws CouldntSaveDataException {
        this.createOrUpdatePointer();
    }
}

