/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableRowData;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class MemberTableModel
extends AbstractTableModel {
    private static final String[] COLUMN_HEADERS = new String[]{"Offset (bytes) / Argument index", "Type", "Name"};
    private final List<MemberTableRowData> model = new ArrayList<MemberTableRowData>();
    private final List<Boolean> validRows = new ArrayList<Boolean>();
    private boolean isOffsetEditable = true;
    public static final int INDEX_COLUMN = 0;
    public static final int TYPE_COLUMN = 1;
    public static final int NAME_COLUMN = 2;

    public void addRow(MemberTableRowData rowData) {
        this.model.add(rowData);
        this.validRows.add(false);
        this.fireTableRowsInserted(this.model.size() - 1, this.model.size() - 1);
    }

    public void addRow(int rowIndex) {
        this.model.add(rowIndex, new MemberTableRowData());
        this.validRows.add(rowIndex, false);
        this.fireTableRowsInserted(rowIndex, rowIndex);
    }

    public void deleteRow(int rowIndex) {
        this.model.remove(rowIndex);
        this.fireTableRowsDeleted(rowIndex, rowIndex);
    }

    @Override
    public Class<?> getColumnClass(int columndIndex) {
        switch (columndIndex) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return BaseType.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        return COLUMN_HEADERS[columnIndex];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        MemberTableRowData element = this.model.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return element.getIndex();
            }
            case 1: {
                return element.getBaseType();
            }
            case 2: {
                return element.getName();
            }
        }
        return null;
    }

    public void setOffsetEditable(boolean value) {
        this.isOffsetEditable = value;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        MemberTableRowData element = this.model.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                element.setIndex((Integer)value);
                break;
            }
            case 1: {
                element.setBaseType((BaseType)value);
                break;
            }
            case 2: {
                element.setName((String)value);
                break;
            }
        }
        this.model.set(rowIndex, element);
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.isOffsetEditable ? true : columnIndex != 0;
    }

    @Override
    public int getRowCount() {
        return this.model.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMN_HEADERS.length;
    }

    public MemberTableRowData getRow(int rowIndex) {
        return this.model.get(rowIndex);
    }

    public void markRow(int rowIndex, boolean valid) {
        this.validRows.set(rowIndex, valid);
    }

    public boolean isRowValid(int rowIndex) {
        if (rowIndex >= this.validRows.size()) {
            return false;
        }
        return this.validRows.get(rowIndex);
    }
}

