/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableMouseListener;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeComboBox;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeListModel;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import java.awt.Color;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;

public class MemberTable
extends JTable {
    public MemberTable(MemberTableModel model, List<BaseType> baseTypes) {
        super(model);
        this.setSurrendersFocusOnKeystroke(true);
        this.addMouseListener(new MemberTableMouseListener(this));
        this.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(new TypeComboBox(new TypeListModel(baseTypes, new TypeListModel.PrototypesFilter()))));
        this.getColumnModel().getColumn(1).setCellRenderer(new BaseTypeCellRenderer());
        this.setFillsViewportHeight(true);
        this.getColumnModel().getColumn(2).setCellRenderer(new InvalidRowTableCellRenderer());
        this.getColumnModel().getColumn(0).setCellRenderer(new InvalidRowTableCellRenderer());
    }

    @Override
    public MemberTableModel getModel() {
        return (MemberTableModel)super.getModel();
    }

    private class BaseTypeCellRenderer
    extends InvalidRowTableCellRenderer {
        private BaseTypeCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            BaseType baseType = (BaseType)value;
            this.setText(baseType == null ? "" : baseType.getName());
        }
    }

    private class InvalidRowTableCellRenderer
    extends DefaultTableCellRenderer {
        private final Color defaultBackgroundColor = UIManager.getColor("Table.dropCellBackground");
        private final Color invalidBackgroundColor = new Color(255, 150, 150);

        public InvalidRowTableCellRenderer() {
            this.setHorizontalAlignment(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelIndex = MemberTable.this.convertRowIndexToModel(row);
            if (MemberTable.this.getModel().isRowValid(modelIndex)) {
                renderer.setBackground(this.defaultBackgroundColor);
            } else {
                renderer.setBackground(this.invalidBackgroundColor);
            }
            return renderer;
        }
    }
}

