/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTable;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableModel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.MemberTableRowData;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeDialogPanel;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.BaseTypeCategory;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import com.google.security.zynamics.binnavi.disassembly.types.TypeMember;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableRowSorter;

public abstract class ComplexTypePanel
extends TypeDialogPanel {
    JTextField name;
    MemberTable members;

    public ComplexTypePanel(Component parent, TypeManager typeManager, BaseType existingType) {
        super(parent, typeManager, existingType);
        this.createControls(typeManager.getTypes());
        this.populateControls();
    }

    private void populateControls() {
        if (this.existingType == null) {
            return;
        }
        this.name.setText(this.existingType.getName());
        MemberTableModel model = this.members.getModel();
        for (TypeMember member : this.existingType) {
            model.addRow(new MemberTableRowData(member));
        }
    }

    private void createControls(List<BaseType> baseTypes) {
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{0, 0, 0};
        gridBagLayout.rowHeights = new int[]{0, 0, 0, 0, 0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 1.0, 1.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JLabel lblName = new JLabel("Name:");
        GridBagConstraints gbcLblName = new GridBagConstraints();
        gbcLblName.insets = new Insets(0, 0, 5, 5);
        gbcLblName.anchor = 17;
        gbcLblName.gridx = 0;
        gbcLblName.gridy = 0;
        this.add((Component)lblName, gbcLblName);
        this.name = new JTextField();
        GridBagConstraints gbcName = new GridBagConstraints();
        gbcName.insets = new Insets(0, 0, 5, 0);
        gbcName.fill = 2;
        gbcName.gridx = 1;
        gbcName.gridy = 0;
        this.add((Component)this.name, gbcName);
        this.name.setColumns(10);
        JLabel lblMembers = new JLabel("Members:");
        GridBagConstraints gbcLblMembers = new GridBagConstraints();
        gbcLblMembers.anchor = 17;
        gbcLblMembers.insets = new Insets(0, 0, 5, 5);
        gbcLblMembers.gridx = 0;
        gbcLblMembers.gridy = 2;
        this.add((Component)lblMembers, gbcLblMembers);
        MemberTableModel model = new MemberTableModel();
        model.addTableModelListener(new MemberTableModelListener());
        this.members = new MemberTable(model, baseTypes);
        TableRowSorter<MemberTableModel> sorter = new TableRowSorter<MemberTableModel>(model);
        sorter.setSortsOnUpdates(true);
        sorter.setSortable(2, false);
        sorter.setSortable(1, false);
        sorter.toggleSortOrder(0);
        this.members.setRowSorter(sorter);
        GridBagConstraints gbcMembers = new GridBagConstraints();
        gbcMembers.insets = new Insets(0, 0, 5, 0);
        gbcMembers.fill = 1;
        gbcMembers.gridx = 1;
        gbcMembers.gridy = 2;
        this.add((Component)new JScrollPane(this.members), gbcMembers);
        JLabel lblPreview = new JLabel("Preview:");
        GridBagConstraints gbcLblPreview = new GridBagConstraints();
        gbcLblPreview.anchor = 17;
        gbcLblPreview.insets = new Insets(0, 0, 0, 5);
        gbcLblPreview.gridx = 0;
        gbcLblPreview.gridy = 3;
        this.add((Component)lblPreview, gbcLblPreview);
        JTextArea preview = new JTextArea();
        GridBagConstraints gbcPreview = new GridBagConstraints();
        gbcPreview.fill = 1;
        gbcPreview.gridx = 1;
        gbcPreview.gridy = 3;
        this.add((Component)preview, gbcPreview);
    }

    protected boolean validateTableRow(int rowIndex) {
        MemberTableRowData row = this.members.getModel().getRow(this.members.convertRowIndexToModel(rowIndex));
        return !row.getName().isEmpty() && row.getBaseType() != null;
    }

    private boolean hasMemberChanged(TypeMember typeMember, MemberTableRowData row) {
        boolean condition;
        boolean bl2 = condition = !row.getName().equals(typeMember.getName()) || !row.getBaseType().equals(typeMember.getBaseType());
        if (typeMember.getParentType().getCategory() == BaseTypeCategory.FUNCTION_PROTOTYPE) {
            return condition || !row.getIndex().equals(typeMember.getArgumentIndex());
        }
        return condition || !row.getIndex().equals(typeMember.getByteOffset());
    }

    protected void createOrUpdateMembers(BaseType containingType, MemberTableModel model) throws CouldntSaveDataException {
        block5: for (int i2 = 0; i2 < model.getRowCount(); ++i2) {
            MemberTableRowData row = model.getRow(i2);
            int index = row.getIndex();
            int bitSize = index * 8;
            boolean isNew = row.getExistingMember() == null;
            switch (containingType.getCategory()) {
                case STRUCT: {
                    if (isNew) {
                        this.typeManager.createStructureMember(containingType, row.getBaseType(), row.getName(), bitSize);
                        continue block5;
                    }
                    if (!this.hasMemberChanged(row.getExistingMember(), row)) continue block5;
                    this.typeManager.updateStructureMember(row.getExistingMember(), row.getBaseType(), row.getName(), bitSize);
                    continue block5;
                }
                case UNION: {
                    if (isNew) {
                        this.typeManager.createUnionMember(containingType, row.getBaseType(), row.getName());
                        continue block5;
                    }
                    if (!this.hasMemberChanged(row.getExistingMember(), row)) continue block5;
                    this.typeManager.updateUnionMember(row.getExistingMember(), row.getBaseType(), row.getName());
                    continue block5;
                }
                case FUNCTION_PROTOTYPE: {
                    if (isNew) {
                        this.typeManager.createFunctionPrototypeMember(containingType, row.getBaseType(), row.getName(), index);
                        continue block5;
                    }
                    if (!this.hasMemberChanged(row.getExistingMember(), row)) continue block5;
                    this.typeManager.updateFunctionPrototypeMember(row.getExistingMember(), row.getBaseType(), row.getName(), index);
                    continue block5;
                }
                default: {
                    throw new IllegalStateException("Error: can not update member in non compound type.");
                }
            }
        }
    }

    private class MemberTableModelListener
    implements TableModelListener {
        private MemberTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent event) {
            if (event.getType() == 1 || event.getType() == 0) {
                MemberTableModel model = ComplexTypePanel.this.members.getModel();
                for (int i2 = 0; i2 < model.getRowCount(); ++i2) {
                    int modelIndex = ComplexTypePanel.this.members.convertRowIndexToModel(i2);
                    boolean validate2 = ComplexTypePanel.this.validateTableRow(i2);
                    model.markRow(modelIndex, validate2);
                }
            }
        }
    }
}

