/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.binnavi.Gui.GraphWindows.types;

import com.google.security.zynamics.binnavi.Database.Exceptions.CouldntSaveDataException;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.TypeDialogPanel;
import com.google.security.zynamics.binnavi.Gui.GraphWindows.types.UserInputTypeValidation;
import com.google.security.zynamics.binnavi.disassembly.types.BaseType;
import com.google.security.zynamics.binnavi.disassembly.types.TypeManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

public class AtomicTypePanel
extends TypeDialogPanel {
    private JTextField size;
    private JTextField name;
    private JCheckBox signed;
    private JLabel lblPreview;
    private JTextArea preview;

    private AtomicTypePanel() {
        this(null, null);
    }

    public AtomicTypePanel(Component parent, TypeManager typeManager) {
        this(parent, typeManager, null);
    }

    public AtomicTypePanel(Component parent, TypeManager typeManager, BaseType existingType) {
        super(parent, typeManager, existingType);
        this.createControls();
        this.populateControls();
    }

    private void createControls() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.add((Component)contentPanel, "Center");
        GridBagLayout gbl_m_contentPanel = new GridBagLayout();
        gbl_m_contentPanel.columnWidths = new int[]{0, 0, 0};
        gbl_m_contentPanel.rowHeights = new int[]{0, 0, 0, 0, 0, 0};
        gbl_m_contentPanel.columnWeights = new double[]{0.0, 1.0, Double.MIN_VALUE};
        gbl_m_contentPanel.rowWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0, Double.MIN_VALUE};
        contentPanel.setLayout(gbl_m_contentPanel);
        JLabel lblNewLabel = new JLabel("Name:");
        GridBagConstraints gbc_lblNewLabel = new GridBagConstraints();
        gbc_lblNewLabel.anchor = 17;
        gbc_lblNewLabel.insets = new Insets(0, 0, 5, 5);
        gbc_lblNewLabel.gridx = 0;
        gbc_lblNewLabel.gridy = 0;
        contentPanel.add((Component)lblNewLabel, gbc_lblNewLabel);
        this.name = new JTextField();
        this.name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e2) {
                AtomicTypePanel.this.updatePreview();
            }
        });
        GridBagConstraints gbc_m_name = new GridBagConstraints();
        gbc_m_name.insets = new Insets(0, 0, 5, 0);
        gbc_m_name.fill = 2;
        gbc_m_name.gridx = 1;
        gbc_m_name.gridy = 0;
        contentPanel.add((Component)this.name, gbc_m_name);
        this.name.setColumns(10);
        JLabel lblSize = new JLabel("Size (bits):");
        GridBagConstraints gbc_lblSize = new GridBagConstraints();
        gbc_lblSize.anchor = 17;
        gbc_lblSize.insets = new Insets(0, 0, 5, 5);
        gbc_lblSize.gridx = 0;
        gbc_lblSize.gridy = 1;
        contentPanel.add((Component)lblSize, gbc_lblSize);
        this.size = new JTextField();
        GridBagConstraints gbc_m_size = new GridBagConstraints();
        gbc_m_size.insets = new Insets(0, 0, 5, 0);
        gbc_m_size.fill = 2;
        gbc_m_size.gridx = 1;
        gbc_m_size.gridy = 1;
        contentPanel.add((Component)this.size, gbc_m_size);
        this.size.setColumns(10);
        this.signed = new JCheckBox("Signed");
        GridBagConstraints gbc_m_signed = new GridBagConstraints();
        gbc_m_signed.anchor = 17;
        gbc_m_signed.insets = new Insets(0, 0, 5, 5);
        gbc_m_signed.gridx = 0;
        gbc_m_signed.gridy = 2;
        contentPanel.add((Component)this.signed, gbc_m_signed);
        this.lblPreview = new JLabel("Preview:");
        GridBagConstraints gbc_lblPreview = new GridBagConstraints();
        gbc_lblPreview.insets = new Insets(0, 0, 5, 5);
        gbc_lblPreview.gridx = 0;
        gbc_lblPreview.gridy = 3;
        contentPanel.add((Component)this.lblPreview, gbc_lblPreview);
        this.preview = new JTextArea();
        this.preview.setEditable(false);
        GridBagConstraints gbc_preview = new GridBagConstraints();
        gbc_preview.insets = new Insets(0, 0, 5, 0);
        gbc_preview.fill = 1;
        gbc_preview.gridx = 1;
        gbc_preview.gridy = 3;
        contentPanel.add((Component)this.preview, gbc_preview);
    }

    private void populateControls() {
        if (this.existingType == null) {
            return;
        }
        this.name.setText(this.existingType.getName());
        this.signed.setSelected(this.existingType.isSigned());
        this.size.setText(String.valueOf(this.existingType.getBitSize()));
        this.updatePreview();
    }

    private void updatePreview() {
        if (!this.name.getText().isEmpty()) {
            this.preview.setText(String.format("%s %s", this.name.getText(), " my_new_type;"));
        }
    }

    private boolean validateOnCreate() {
        return UserInputTypeValidation.validateTypeName(this.parent, this.typeManager, this.name) && UserInputTypeValidation.validateTypeSize(this.parent, this.size);
    }

    private boolean validateOnUpdate() {
        return !this.name.getText().isEmpty() && UserInputTypeValidation.validateTypeSize(this.parent, this.size);
    }

    @Override
    protected boolean validateModel() {
        return this.existingType == null ? this.validateOnCreate() : this.validateOnUpdate();
    }

    @Override
    protected void updateExistingType() throws CouldntSaveDataException {
        this.typeManager.updateType(this.existingType, this.name.getText(), Integer.parseInt(this.size.getText()), this.signed.isSelected());
    }

    @Override
    protected void createNewType() throws CouldntSaveDataException {
        this.typeManager.createAtomicType(this.name.getText(), Integer.parseInt(this.size.getText()), this.signed.isSelected());
    }
}

